/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.Options;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.CommandException;
import org.bonitasoft.platform.setup.command.CommandUtils;
import org.bonitasoft.platform.setup.command.PlatformSetupCommand;
import org.bonitasoft.platform.setup.command.configure.PropertyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitCommand
extends PlatformSetupCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitCommand.class);

    public InitCommand() {
        super("init", "Initialise the database so that Bonita is ready to run with this database", CommandUtils.getFileContentFromClassPath("init_header.txt"), CommandUtils.getFileContentFromClassPath("init_footer.txt"));
    }

    @Override
    public void execute(Options options, String ... args) throws PlatformException, CommandException {
        this.askConfirmationIfH2();
        this.getPlatformSetup(args).init();
    }

    void askConfirmationIfH2() throws PlatformException, CommandException {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("/database.properties"));
            PropertyReader propertyReader = new PropertyReader(properties);
            if ("h2".equals(propertyReader.getPropertyAndFailIfNull("db.vendor")) && "h2".equals(propertyReader.getPropertyAndFailIfNull("bdm.db.vendor")) && System.getProperty("h2.noconfirm") == null) {
                this.warn("Default H2 configuration detected. This is not recommended for production. If this is not the required configuration, change file 'database.properties' and run again.");
                System.out.print("Are you sure you want to continue? (y/n): ");
                String answer = this.readAnswer();
                if (!"y".equalsIgnoreCase(answer)) {
                    throw new CommandException("Default H2 configuration not confirmed. Exiting.");
                }
            }
        }
        catch (IOException e) {
            throw new PlatformException("Error reading configuration file database.properties. Please make sure the file is present at the root of the Platform Setup Tool folder, and that is has not been moved of deleted", e);
        }
    }

    String readAnswer() throws IOException {
        byte[] read = new byte[1];
        System.in.read(read);
        return new String(read);
    }

    void warn(String message) {
        LOGGER.warn(message);
    }
}

