/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.BundleConfigurator;
import org.bonitasoft.platform.setup.command.configure.TomcatBundleConfigurator;
import org.bonitasoft.platform.setup.command.configure.WildflyBundleConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleResolver {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BundleConfigurator.class);
    private final Path rootPath;

    BundleResolver() {
        String setupFolder = System.getProperty("org.bonitasoft.platform.setup.folder");
        this.rootPath = setupFolder != null ? Paths.get(setupFolder, new String[0]).getParent() : Paths.get("..", new String[0]);
    }

    private boolean fileExists(Path filePath) {
        boolean exists = Files.exists(filePath, new LinkOption[0]);
        if (!exists) {
            LOGGER.debug("File " + filePath.toString() + " does not exist.");
        }
        return exists;
    }

    protected Path getPath(String partialPath) throws PlatformException {
        String[] paths = partialPath.split("/");
        Path build = this.rootPath;
        for (String path : paths) {
            build = build.resolve(path);
        }
        return build;
    }

    private boolean isTomcatEnvironment() throws PlatformException {
        return this.fileExists(this.getPath("server/bin/catalina.sh")) || this.fileExists(this.getPath("server/bin/catalina.bat"));
    }

    private boolean isWildflyEnvironment() throws PlatformException {
        return this.fileExists(this.getPath("server/bin/standalone.conf")) || this.fileExists(this.getPath("server/bin/standalone.conf.bat"));
    }

    BundleConfigurator getConfigurator() throws PlatformException {
        if (this.isTomcatEnvironment()) {
            return new TomcatBundleConfigurator(this.rootPath);
        }
        if (this.isWildflyEnvironment()) {
            return new WildflyBundleConfigurator(this.rootPath);
        }
        LOGGER.info("No Application Server detected. You may need to manually configure the access to the database. Supported App Servers are: Tomcat 8, Wildfly 10");
        return null;
    }
}

