/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.version.impl;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.version.VersionService;
import org.bonitasoft.platform.version.impl.PlatformRowMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class VersionServiceImpl
implements VersionService {
    public static final String SQL_PLATFORM_VERSION = "SELECT p.version FROM platform p ORDER BY p.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionServiceImpl.class);
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public VersionServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getPlatformVersion() throws PlatformException {
        List strings;
        try {
            strings = this.jdbcTemplate.query(SQL_PLATFORM_VERSION, (RowMapper)new PlatformRowMapper());
        }
        catch (DataAccessException e) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.", (Exception)((Object)e));
        }
        if (this.hasNotSingleResult(strings)) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.");
        }
        return (String)strings.get(0);
    }

    private boolean hasNotSingleResult(List<String> strings) {
        return strings == null || strings.size() != 1;
    }

    @Override
    public String getPlatformSetupVersion() {
        String version = null;
        try {
            version = IOUtils.toString((URL)this.getClass().getResource("/PLATFORM_ENGINE_VERSION"));
        }
        catch (IOException e) {
            LOGGER.error("unable to read version.");
        }
        return version;
    }

    @Override
    public boolean isValidPlatformVersion() throws PlatformException {
        return this.getPlatformVersion().equals(this.getPlatformSetupVersion());
    }
}

