/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.version.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:/application.properties"})
public class ScriptExecutor {
    public static final boolean CONTINUE_ON_ERROR = true;
    public static final boolean FAIL_ON_ERROR = false;
    private final Logger logger = LoggerFactory.getLogger(ScriptExecutor.class);
    private final String sqlFolder;
    private final DataSource datasource;
    private final String dbVendor;
    private VersionService versionService;

    @Autowired
    public ScriptExecutor(@Value(value="${db.vendor}") String dbVendor, DataSource datasource, VersionService versionService) {
        if (dbVendor == null) {
            throw new IllegalArgumentException("dbVendor is null");
        }
        this.dbVendor = dbVendor;
        this.datasource = datasource;
        this.logger.info("configuration for Database vendor: " + dbVendor);
        this.sqlFolder = "/sql/" + dbVendor;
        this.versionService = versionService;
    }

    public void createTables() throws PlatformException {
        try {
            this.executeSQLResources(Arrays.asList("createTables.sql", "createQuartzTables.sql", "postCreateStructure.sql"), false);
        }
        catch (IOException | SQLException e) {
            throw new PlatformException(e);
        }
    }

    public void createAndInitializePlatformIfNecessary() throws PlatformException {
        if (!this.isPlatformAlreadyCreated()) {
            this.createTables();
            this.initializePlatformStructure();
            this.insertPlatform();
        } else {
            this.logger.info("Bonita platform already exists. Nothing to do. Stopping.");
        }
    }

    protected void insertPlatform() throws PlatformException {
        String version = this.versionService.getPlatformSetupVersion();
        String sql = "INSERT INTO platform (id, version, previousversion, initialversion, created, createdby) VALUES (1, '" + version + "', '', '" + version + "', " + System.currentTimeMillis() + ", 'platformAdmin')";
        new JdbcTemplate(this.datasource).update(sql);
    }

    public boolean isPlatformAlreadyCreated() {
        try {
            return (Integer)new JdbcTemplate(this.datasource).queryForObject("select count(*) from sequence", Integer.class) > 0;
        }
        catch (DataAccessException e) {
            return false;
        }
    }

    protected void executeSQLResources(List<String> sqlFiles, boolean shouldContinueOnError) throws IOException, SQLException {
        for (String sqlFile : sqlFiles) {
            this.executeSQLResource(sqlFile, shouldContinueOnError);
        }
    }

    private Resource getSQLResource(String sqlFolder, String sqlFile) {
        String setupFolderPath = System.getProperty("org.bonitasoft.platform.setup.folder");
        if (setupFolderPath != null) {
            return this.getResourceFromFileSystem(setupFolderPath, sqlFile);
        }
        return this.getResourceFromClassPath(sqlFolder, sqlFile);
    }

    private Resource getResourceFromFileSystem(String setupFolderPath, String sqlFile) {
        Path path = Paths.get(setupFolderPath, new String[0]).resolve("platform_conf").resolve("sql").resolve(this.dbVendor).resolve(sqlFile);
        File file = path.toFile();
        if (file.exists()) {
            return new FileSystemResource(file);
        }
        String msg = "SQL resource file not found in filesystem: " + file.getAbsolutePath();
        this.logger.error(msg);
        throw new RuntimeException(msg);
    }

    private Resource getResourceFromClassPath(String sqlFolder, String sqlFile) {
        String resourcePath = sqlFolder + "/" + sqlFile;
        URL url = this.getClass().getResource(resourcePath);
        if (url != null) {
            return new UrlResource(url);
        }
        String msg = "SQL resource file not found in classpath: " + resourcePath;
        this.logger.warn(msg);
        throw new RuntimeException(msg);
    }

    protected void executeSQLResource(String sqlFile, boolean shouldContinueOnError) throws IOException, SQLException {
        Resource sqlResource = this.getSQLResource(this.sqlFolder, sqlFile);
        ResourceDatabasePopulator populate = new ResourceDatabasePopulator();
        populate.setContinueOnError(shouldContinueOnError);
        populate.setIgnoreFailedDrops(true);
        populate.addScript(sqlResource);
        populate.setSeparator(this.getSeparator());
        populate.execute(this.datasource);
        this.logger.info("Executed SQL script " + sqlResource.getURL().getFile());
    }

    private String getSeparator() {
        if ("sqlserver".equals(this.dbVendor)) {
            return "GO";
        }
        return ";";
    }

    public void initializePlatformStructure() throws PlatformException {
        try {
            this.executeSQLResources(Collections.singletonList("initTables.sql"), false);
        }
        catch (IOException | SQLException e) {
            throw new PlatformException(e);
        }
    }

    public void deleteTables() throws PlatformException {
        try {
            this.executeSQLResources(Arrays.asList("preDropStructure.sql", "dropQuartzTables.sql", "dropTables.sql"), true);
        }
        catch (IOException | SQLException e) {
            throw new PlatformException(e);
        }
    }
}

