/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationTenantUpdater;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class UpdateConfigurationInTransactionForAllTenants
extends TransactionCallbackWithoutResult {
    private final JdbcTemplate jdbcTemplate;
    private final List<BonitaConfiguration> bonitaConfigurations;
    private final ConfigurationType type;
    private final String dbVendor;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateConfigurationInTransactionForAllTenants.class);

    public UpdateConfigurationInTransactionForAllTenants(JdbcTemplate jdbcTemplate, String dbVendor, List<BonitaConfiguration> bonitaConfigurations, ConfigurationType type) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbVendor = dbVendor;
        this.bonitaConfigurations = bonitaConfigurations;
        this.type = type;
    }

    protected void doInTransactionWithoutResult(TransactionStatus status) {
        LOGGER.debug("Updating configuration files " + this.bonitaConfigurations.toString() + " of type:" + this.type.name() + " for all tenants");
        this.jdbcTemplate.batchUpdate("UPDATE configuration SET resource_content=? WHERE content_type=? AND resource_name=?", (BatchPreparedStatementSetter)new BonitaConfigurationTenantUpdater(this.bonitaConfigurations, this.dbVendor, this.type));
    }
}

