/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaAllConfigurationContentTypeCleaner;
import org.bonitasoft.platform.configuration.impl.BonitaAllConfigurationPreparedStatementSetter;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class CleanAndStoreAllConfigurationInTransaction
extends TransactionCallbackWithoutResult {
    private final JdbcTemplate jdbcTemplate;
    private final List<FullBonitaConfiguration> bonitaConfigurations;
    private final String dbVendor;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    public CleanAndStoreAllConfigurationInTransaction(JdbcTemplate jdbcTemplate, String dbVendor, List<FullBonitaConfiguration> bonitaConfigurations) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbVendor = dbVendor;
        this.bonitaConfigurations = bonitaConfigurations;
    }

    protected void doInTransactionWithoutResult(TransactionStatus status) {
        LOGGER.debug("delete existing configurations " + this.bonitaConfigurations.toString());
        this.jdbcTemplate.batchUpdate("DELETE from configuration where tenant_id = ? and content_type = ? and resource_name = ? ", (BatchPreparedStatementSetter)new BonitaAllConfigurationContentTypeCleaner(this.bonitaConfigurations));
        this.jdbcTemplate.batchUpdate("INSERT into configuration(tenant_id, content_type, resource_name, resource_content) values (?,?,?,?)", (BatchPreparedStatementSetter)new BonitaAllConfigurationPreparedStatementSetter(this.bonitaConfigurations, this.dbVendor));
    }
}

