/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.DatabaseConfiguration;
import org.bonitasoft.platform.setup.command.configure.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BundleConfigurator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BundleConfigurator.class);
    static final String H2 = "h2";
    static final String MYSQL = "mysql";
    static final String ORACLE = "oracle";
    static final String POSTGRES = "postgres";
    static final String SQLSERVER = "sqlserver";
    private static final String TOMCAT_TEMPLATES_FOLDER = "tomcat-templates";
    static final String APPSERVER_FOLDERNAME = "server";
    private Path rootPath;
    DatabaseConfiguration standardConfiguration;
    DatabaseConfiguration bdmConfiguration;
    private Path backupsFolder;
    private String timestamp;

    BundleConfigurator(Path rootPath) throws PlatformException {
        try {
            this.rootPath = rootPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new PlatformException("Unable to determine root path for " + this.getBundleName());
        }
        this.timestamp = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'").format(new Date());
    }

    void loadProperties() throws PlatformException {
        Properties properties = new PropertyLoader().loadProperties();
        this.standardConfiguration = new DatabaseConfiguration("", properties, this.rootPath);
        this.bdmConfiguration = new DatabaseConfiguration("bdm.", properties, this.rootPath);
        try {
            Path dbFile = Paths.get(this.getClass().getResource("/database.properties").toURI());
            LOGGER.info(this.getBundleName() + " environment detected with root " + this.rootPath);
            LOGGER.info("Running auto-configuration using file " + dbFile.normalize());
        }
        catch (URISyntaxException e) {
            throw new PlatformException("Configuration file 'database.properties' not found");
        }
    }

    protected abstract String getBundleName();

    abstract void configureApplicationServer() throws PlatformException;

    void createBackupFolderIfNecessary(String backupFolder) throws PlatformException {
        this.backupsFolder = this.getPath(backupFolder);
        if (Files.notExists(this.backupsFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(this.backupsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PlatformException("Could not create backup folder: " + backupFolder, e);
            }
        }
    }

    Path getTemplateFolderPath(String templateFile) throws PlatformException {
        return this.getPath("setup").resolve(TOMCAT_TEMPLATES_FOLDER).resolve(templateFile);
    }

    void backupAndReplaceContentIfNecessary(Path path, String newContent, String message) throws PlatformException {
        String previousContent = this.readContentFromFile(path);
        if (!previousContent.equals(newContent)) {
            this.makeBackupOfFile(path);
            this.writeContentToFile(path, newContent);
            LOGGER.info(message);
        } else {
            LOGGER.info("Same configuration detected for file '" + this.getRelativePath(path) + "'. No need to change it.");
        }
    }

    boolean copyDatabaseDriversIfNecessary(Path srcDriverFile, Path targetDriverFile, String dbVendor) throws PlatformException {
        if (srcDriverFile == null || targetDriverFile == null) {
            return false;
        }
        if (Files.exists(targetDriverFile, new LinkOption[0])) {
            LOGGER.info("Your " + dbVendor + " driver file '" + this.getRelativePath(targetDriverFile) + "' already exists. Skipping the copy.");
            return false;
        }
        this.copyDriverFile(srcDriverFile, targetDriverFile, dbVendor);
        return true;
    }

    Path getRelativePath(Path pathToRelativize) {
        return this.rootPath.toAbsolutePath().relativize(pathToRelativize.toAbsolutePath());
    }

    void copyDriverFile(Path srcDriverFile, Path targetDriverFile, String dbVendor) throws PlatformException {
        try {
            Path targetDriverFolder = targetDriverFile.getParent();
            targetDriverFolder.toFile().mkdirs();
            Files.copy(srcDriverFile, targetDriverFile, new CopyOption[0]);
            LOGGER.info("Copying your " + dbVendor + " driver file '" + this.getRelativePath(srcDriverFile) + "' to tomcat lib folder '" + this.getRelativePath(targetDriverFolder) + "'");
        }
        catch (IOException e) {
            throw new PlatformException("Fail to copy driver file lib/" + srcDriverFile.getFileName() + " to " + targetDriverFile.toAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    static String replaceValues(String content, Map<String, String> replacementMap) {
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            content = content.replaceAll(entry.getKey(), entry.getValue());
        }
        return content;
    }

    static String convertWindowsBackslashes(String value) {
        return value.replaceAll("\\\\", "/");
    }

    void writeContentToFile(Path path, String content) throws PlatformException {
        try {
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new PlatformException("Fail to replace content in file " + path + ": " + e.getMessage(), e);
        }
    }

    String readContentFromFile(Path bonitaXmlFile) throws PlatformException {
        try {
            return new String(Files.readAllBytes(bonitaXmlFile), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new PlatformException("Cannot read content of text file " + bonitaXmlFile.toAbsolutePath().toString(), e);
        }
    }

    void restoreOriginalFile(Path bonitaXmlFile) throws PlatformException {
        try {
            Path backupFile;
            if (Files.exists(bonitaXmlFile, new LinkOption[0])) {
                Files.delete(bonitaXmlFile);
            }
            if (Files.exists(backupFile = this.getBackupFile(bonitaXmlFile), new LinkOption[0])) {
                Files.move(backupFile, bonitaXmlFile, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new PlatformException("Fail to restore original file for " + bonitaXmlFile + ": " + e.getMessage(), e);
        }
    }

    private Path makeBackupOfFile(Path originalFile) throws PlatformException {
        Path originalFileName = originalFile.getFileName();
        Path backup = this.getBackupFile(originalFile);
        LOGGER.info("Creating a backup of configuration file '" + this.getRelativePath(originalFile).normalize() + "' to '" + this.getRelativePath(backup).normalize() + "'");
        try {
            Files.copy(originalFile, backup, new CopyOption[0]);
            return backup;
        }
        catch (IOException e) {
            throw new PlatformException("Fail to make backup file for " + originalFileName + ": " + e.getMessage(), e);
        }
    }

    private Path getBackupFile(Path originalFile) {
        return this.backupsFolder.resolve(originalFile.getFileName() + "." + this.getTimestamp());
    }

    private String getTimestamp() {
        return this.timestamp;
    }

    File getDriverFile(String dbVendor) throws PlatformException {
        Path driverFolder = this.getPath("setup/lib");
        if (!Files.exists(driverFolder, new LinkOption[0])) {
            throw new PlatformException("Drivers folder not found: " + driverFolder.toString() + ". Make sure it exists and put a jar or zip file containing drivers there.");
        }
        Collection driversFiles = FileUtils.listFiles((File)driverFolder.toFile(), (IOFileFilter)this.getDriverFilter(dbVendor), null);
        if (driversFiles.size() == 0) {
            throw new PlatformException("No " + dbVendor + " drivers found in folder " + driverFolder.toString() + ". Make sure to put a jar or zip file containing drivers there.");
        }
        if (driversFiles.size() == 1) {
            return (File)driversFiles.toArray()[0];
        }
        throw new PlatformException("Found more than 1 file containing " + dbVendor + " drivers  in folder " + driverFolder.toString() + ". Make sure to put only 1 jar or zip file containing drivers there.");
    }

    RegexFileFilter getDriverFilter(String dbVendor) {
        return new RegexFileFilter(this.getDriverPattern(dbVendor), IOCase.INSENSITIVE);
    }

    private String getDriverPattern(String dbVendor) {
        if (ORACLE.equals(dbVendor)) {
            return ".*(ojdbc|oracle).*\\.(jar|zip)";
        }
        if (SQLSERVER.equals(dbVendor)) {
            return ".*(sqlserver|mssql|sqljdbc).*\\.(jar|zip)";
        }
        return ".*" + dbVendor + ".*";
    }

    protected Path getPath(String partialPath) throws PlatformException {
        return this.getPath(partialPath, false);
    }

    protected Path getPath(String partialPath, boolean failIfNotExist) throws PlatformException {
        String[] paths = partialPath.split("/");
        Path build = this.rootPath;
        for (String path : paths) {
            build = build.resolve(path);
        }
        if (failIfNotExist && Files.notExists(build, new LinkOption[0])) {
            throw new PlatformException("File " + build.getFileName() + " is mandatory but is not found");
        }
        return build;
    }

    static String escapeXmlCharacters(String url) {
        return StringEscapeUtils.escapeXml11((String)url);
    }

    protected Path getOptionalPathUnderAppServer(String path) throws PlatformException {
        return this.getPath("server/" + path, false);
    }

    protected Path getPathUnderAppServer(String path, boolean failIfNotExist) throws PlatformException {
        return this.getPath("server/" + path, failIfNotExist);
    }

    protected static String getDatabaseConnectionUrlForXmlFile(DatabaseConfiguration configuration) {
        return BundleConfigurator.escapeXmlCharacters(Matcher.quoteReplacement(BundleConfigurator.getDatabaseConnectionUrl(configuration)));
    }

    protected static String getDatabaseConnectionUrlForPropertiesFile(DatabaseConfiguration configuration) {
        String url = BundleConfigurator.getDatabaseConnectionUrl(configuration);
        if (H2.equals(configuration.getDbVendor())) {
            url = StringEscapeUtils.escapeJava((String)url);
        }
        return Matcher.quoteReplacement(url);
    }

    static String getDatabaseConnectionUrl(DatabaseConfiguration configuration) {
        String url = configuration.getUrl();
        if (H2.equals(configuration.getDbVendor())) {
            url = BundleConfigurator.convertWindowsBackslashes(url);
        }
        return url;
    }
}

