/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.Contract;
import org.bonitasoft.web.client.model.DesignProcessDefinition;
import org.bonitasoft.web.client.model.ProcessCreateRequest;
import org.bonitasoft.web.client.model.ProcessDefinition;
import org.bonitasoft.web.client.model.ProcessInstantiationResponse;
import org.bonitasoft.web.client.model.ProcessUpdateRequest;

public interface ProcessApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/bpm/process")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ProcessDefinition createProcess(ProcessCreateRequest var1);

    @RequestLine(value="DELETE /API/bpm/process/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteProcessById(@Param(value="id") String var1);

    @RequestLine(value="DELETE /API/bpm/process")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void deleteProcessByIds(List<String> var1);

    @RequestLine(value="GET /API/bpm/process/{id}")
    @Headers(value={"Accept: application/json"})
    public ProcessDefinition getProcessById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/bpm/process/{id}/contract")
    @Headers(value={"Accept: application/json"})
    public Contract getProcessContractById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/bpm/process/{id}/design")
    @Headers(value={"Accept: application/json"})
    public DesignProcessDefinition getProcessDesignById(@Param(value="id") String var1);

    @RequestLine(value="POST /API/bpm/process/{id}/instantiation")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ProcessInstantiationResponse instanciateProcess(@Param(value="id") String var1, Map<String, Object> var2);

    @RequestLine(value="GET /API/bpm/process?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<ProcessDefinition> searchProcesses(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4, @Param(value="s") String var5);

    @RequestLine(value="GET /API/bpm/process?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<ProcessDefinition> searchProcesses(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /API/bpm/process/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateProcessById(@Param(value="id") String var1, ProcessUpdateRequest var2);

    @RequestLine(value="POST /portal/processUpload")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public String uploadProcess(@Param(value="file") File var1);

    public static class SearchProcessesQueryParams
    extends HashMap<String, Object> {
        public SearchProcessesQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchProcessesQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchProcessesQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchProcessesQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }

        public SearchProcessesQueryParams s(String value) {
            this.put("s", EncodingUtils.encode(value));
            return this;
        }
    }
}

