/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.Tenant;
import org.bonitasoft.web.client.model.TenantCreateRequest;
import org.bonitasoft.web.client.model.TenantUpdateRequest;

public interface TenantApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/platform/tenant")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tenant createTenant(TenantCreateRequest var1);

    @RequestLine(value="DELETE /API/platform/tenant/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteTenantById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/platform/tenant/{id}")
    @Headers(value={"Accept: application/json"})
    public Tenant getTenantById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/platform/tenant?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<Tenant> searchTenants(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4, @Param(value="s") String var5);

    @RequestLine(value="GET /API/platform/tenant?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<Tenant> searchTenants(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /API/platform/tenant/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateTenantById(@Param(value="id") String var1, TenantUpdateRequest var2);

    public static class SearchTenantsQueryParams
    extends HashMap<String, Object> {
        public SearchTenantsQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchTenantsQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchTenantsQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchTenantsQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }

        public SearchTenantsQueryParams s(String value) {
            this.put("s", EncodingUtils.encode(value));
            return this;
        }
    }
}

