/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.User;
import org.bonitasoft.web.client.model.UserCreateRequest;
import org.bonitasoft.web.client.model.UserUpdateRequest;

public interface UserApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/identity/user")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User createUser(UserCreateRequest var1);

    @RequestLine(value="DELETE /API/identity/user/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteUserById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/identity/user/{id}")
    @Headers(value={"Accept: application/json"})
    public User getUserById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/identity/user?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<User> searchUsers(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4, @Param(value="s") String var5);

    @RequestLine(value="GET /API/identity/user?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<User> searchUsers(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /API/identity/user/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateUserById(@Param(value="id") String var1, UserUpdateRequest var2);

    public static class SearchUsersQueryParams
    extends HashMap<String, Object> {
        public SearchUsersQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchUsersQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchUsersQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchUsersQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }

        public SearchUsersQueryParams s(String value) {
            this.put("s", EncodingUtils.encode(value));
            return this;
        }
    }
}

