/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.invoker.ApiClient;

public class CachingApiProvider
implements ApiProvider {
    private final ApiClient apiClient;
    private final Map<Class<?>, ApiClient.Api> apiCache = new ConcurrentHashMap();

    @Override
    public <T extends ApiClient.Api> T get(Class<T> apiClass) {
        if (!this.apiCache.containsKey(apiClass)) {
            T service = this.apiClient.buildClient(apiClass);
            this.apiCache.put(apiClass, (ApiClient.Api)service);
        }
        return (T)this.apiCache.get(apiClass);
    }

    public CachingApiProvider(ApiClient apiClient) {
        this.apiClient = apiClient;
    }
}

