/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign.decoder;

import feign.FeignException;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingDecoder
implements Decoder {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static Logger log = LoggerFactory.getLogger(DelegatingDecoder.class);
    private Map<String, Decoder> delegates = new HashMap<String, Decoder>();
    private Decoder defaultDecoder = new Decoder.Default();

    public DelegatingDecoder() {
    }

    public DelegatingDecoder(Map<String, Decoder> delegates) {
        this.delegates.putAll(delegates);
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        Collection contentTypeHeader = (Collection)response.headers().get(CONTENT_TYPE_HEADER);
        if (contentTypeHeader == null) {
            return this.defaultDecoder.decode(response, type);
        }
        String contentType = (String)contentTypeHeader.stream().findFirst().orElseThrow(() -> new RuntimeException("No Content-Type header in response headers."));
        log.debug("Decoding body with content-type: {}", (Object)contentType);
        return this.delegates.entrySet().stream().filter(this.contentTypeRegistered(contentType)).findFirst().map(Map.Entry::getValue).map(decoder -> this.decodeNoException((Decoder)decoder, response, type)).orElseGet(() -> this.decodeNoException(this.defaultDecoder, response, type));
    }

    private Predicate<Map.Entry<String, Decoder>> contentTypeRegistered(String contentType) {
        return decoderEntry -> {
            String registeredType = ((String)decoderEntry.getKey()).toLowerCase();
            String responseContentType = contentType.toLowerCase();
            return responseContentType.startsWith(registeredType);
        };
    }

    private Object decodeNoException(Decoder decoder, Response response, Type type) {
        try {
            Object object = decoder.decode(response, type);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            response.close();
        }
    }

    public DelegatingDecoder register(String contentType, Decoder decoder) {
        this.delegates.put(contentType, decoder);
        return this;
    }
}

