/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.invoker.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import org.bonitasoft.web.client.api.PortalAuthenticationApi;
import org.bonitasoft.web.client.api.SessionApi;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.exception.UnauthorizedException;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.invoker.auth.BonitaCookieAuth;
import org.bonitasoft.web.client.model.Session;
import org.bonitasoft.web.client.services.LoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonitaLoginService
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(BonitaLoginService.class);
    private final ApiProvider apiProvider;
    private final ObjectMapper objectMapper;
    private final BonitaCookieAuth bonitaCookieAuth;

    @Override
    public Session login(String username, String password, String tenant) {
        block10: {
            log.debug("Login with user '{}' on tenant '{}'...", (Object)username, (Object)tenant);
            try (Response loginResponse = this.apiProvider.get(PortalAuthenticationApi.class).login(username, password, tenant, "false", "");){
                if (loginResponse.status() == 200 || loginResponse.status() == 204) {
                    this.bonitaCookieAuth.setSessionCookies(loginResponse.headers());
                    break block10;
                }
                throw new UnauthorizedException(String.format("Login failed, status: %S %s", loginResponse.status(), loginResponse.reason()));
            }
            catch (UnauthorizedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("Login failed", e);
            }
        }
        Session session = this.getSession();
        log.debug("Login completed. Session: {}", (Object)session);
        return session;
    }

    @Override
    public Session getSession() {
        Session session;
        block8: {
            Response response = this.apiProvider.get(SessionApi.class).getSession();
            Response.Body body = response.body();
            try {
                InputStream inputStream = body.asInputStream();
                session = (Session)this.objectMapper.readValue(inputStream, Session.class);
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClientException("Failed to parse response as a Session:", e);
                }
            }
            body.close();
        }
        return session;
    }

    @Override
    public void logout() {
        log.debug("Logout...");
        this.apiProvider.get(PortalAuthenticationApi.class).logout("false");
        this.bonitaCookieAuth.clearSessionCookie();
        log.debug("Logout completed.");
    }

    public BonitaLoginService(ApiProvider apiProvider, ObjectMapper objectMapper, BonitaCookieAuth bonitaCookieAuth) {
        this.apiProvider = apiProvider;
        this.objectMapper = objectMapper;
        this.bonitaCookieAuth = bonitaCookieAuth;
    }
}

