/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Actor definition")
@JsonPropertyOrder(value={"name", "description", "initiator"})
public class ActorDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_INITIATOR = "initiator";
    private Boolean initiator;

    public ActorDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the actor name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActorDefinition description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the actor description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ActorDefinition initiator(Boolean initiator) {
        this.initiator = initiator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="true, if this actor can start the process")
    @JsonProperty(value="initiator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getInitiator() {
        return this.initiator;
    }

    public void setInitiator(Boolean initiator) {
        this.initiator = initiator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActorDefinition actorDefinition = (ActorDefinition)o;
        return Objects.equals(this.name, actorDefinition.name) && Objects.equals(this.description, actorDefinition.description) && Objects.equals(this.initiator, actorDefinition.initiator);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.initiator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActorDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    initiator: ").append(this.toIndentedString(this.initiator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

