/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An actor member represents the association between the organization and the actor af a process. In an organization we have four member_types = USER, GROUP, ROLE and MEMBERSHIP (role in a group). You can assign a actor to a user by specifying a role and or a group, or specific user.")
@JsonPropertyOrder(value={"id", "actor_id", "role_id", "group_id", "user_id"})
public class ActorMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ACTOR_ID = "actor_id";
    private String actorId;
    public static final String JSON_PROPERTY_ROLE_ID = "role_id";
    private String roleId;
    public static final String JSON_PROPERTY_GROUP_ID = "group_id";
    private String groupId;
    public static final String JSON_PROPERTY_USER_ID = "user_id";
    private String userId;

    public ActorMember id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="actor member id")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActorMember actorId(String actorId) {
        this.actorId = actorId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the actor for this mapping")
    @JsonProperty(value="actor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActorId() {
        return this.actorId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public ActorMember roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of role, or -1 if the member type is not role")
    @JsonProperty(value="role_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public ActorMember groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of group, or -1 if the member type is not group")
    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ActorMember userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of user, or -1 if the member type is not user")
    @JsonProperty(value="user_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActorMember actorMember = (ActorMember)o;
        return Objects.equals(this.id, actorMember.id) && Objects.equals(this.actorId, actorMember.actorId) && Objects.equals(this.roleId, actorMember.roleId) && Objects.equals(this.groupId, actorMember.groupId) && Objects.equals(this.userId, actorMember.userId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.actorId, this.roleId, this.groupId, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActorMember {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    actorId: ").append(this.toIndentedString(this.actorId)).append("\n");
        sb.append("    roleId: ").append(this.toIndentedString(this.roleId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

