/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A flow node (gateway or event or task) in an archived instance of a process.")
@JsonPropertyOrder(value={"sourceObjectId", "archivedDate"})
public class ArchivedFlowNodeAllOf
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_SOURCE_OBJECT_ID = "sourceObjectId";
    private String sourceObjectId;
    public static final String JSON_PROPERTY_ARCHIVED_DATE = "archivedDate";
    private String archivedDate;

    public ArchivedFlowNodeAllOf sourceObjectId(String sourceObjectId) {
        this.sourceObjectId = sourceObjectId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the original id of the flowNode before it was archived")
    @JsonProperty(value="sourceObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceObjectId() {
        return this.sourceObjectId;
    }

    public void setSourceObjectId(String sourceObjectId) {
        this.sourceObjectId = sourceObjectId;
    }

    public ArchivedFlowNodeAllOf archivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date ('yyyy-MM-dd HH:mm:ss.SSS') when the current task was assigned for example '2014-10-17 16:05:42.626'")
    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedFlowNodeAllOf archivedFlowNodeAllOf = (ArchivedFlowNodeAllOf)o;
        return Objects.equals(this.sourceObjectId, archivedFlowNodeAllOf.sourceObjectId) && Objects.equals(this.archivedDate, archivedFlowNodeAllOf.archivedDate);
    }

    public int hashCode() {
        return Objects.hash(this.sourceObjectId, this.archivedDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchivedFlowNodeAllOf {\n");
        sb.append("    sourceObjectId: ").append(this.toIndentedString(this.sourceObjectId)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

