/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Group")
@JsonPropertyOrder(value={"id", "name", "displayName", "parent_path", "path", "description", "creation_date", "created_by_user_id", "last_update_date", "icon"})
public class Group
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_PARENT_PATH = "parent_path";
    private String parentPath;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_CREATION_DATE = "creation_date";
    private String creationDate;
    public static final String JSON_PROPERTY_CREATED_BY_USER_ID = "created_by_user_id";
    private String createdByUserId;
    public static final String JSON_PROPERTY_LAST_UPDATE_DATE = "last_update_date";
    private String lastUpdateDate;
    public static final String JSON_PROPERTY_ICON = "icon";
    private String icon;

    public Group id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="group ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Group name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Group displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="display name")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Group parentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the path of the parent group of this group (empty if the group has no parent)")
    @JsonProperty(value="parent_path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public Group path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the full path of the group (including its parent path)")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Group description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Group creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="creation date (format: `2014-12-31 15:17:24.736`)")
    @JsonProperty(value="creation_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public Group createdByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the user who created the group (-1 if the group was created by the tenant admin or by an organisation import)")
    @JsonProperty(value="created_by_user_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public Group lastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="last update date (format: `2014-12-31 15:17:24.736`)")
    @JsonProperty(value="last_update_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public Group icon(String icon) {
        this.icon = icon;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="icon path")
    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return Objects.equals(this.id, group.id) && Objects.equals(this.name, group.name) && Objects.equals(this.displayName, group.displayName) && Objects.equals(this.parentPath, group.parentPath) && Objects.equals(this.path, group.path) && Objects.equals(this.description, group.description) && Objects.equals(this.creationDate, group.creationDate) && Objects.equals(this.createdByUserId, group.createdByUserId) && Objects.equals(this.lastUpdateDate, group.lastUpdateDate) && Objects.equals(this.icon, group.icon);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.displayName, this.parentPath, this.path, this.description, this.creationDate, this.createdByUserId, this.lastUpdateDate, this.icon);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Group {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    parentPath: ").append(this.toIndentedString(this.parentPath)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    createdByUserId: ").append(this.toIndentedString(this.createdByUserId)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

