/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bonitasoft.web.client.model.MessageMessageContent;

@ApiModel(description="Use this resource to send BPM message events. Message events are caught by processes using `catch message event` flow nodes (Start, intermediate, boundary or receive tasks).")
@JsonPropertyOrder(value={"messageName", "targetProcess", "targetFlowNode", "messageContent", "correlations"})
public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MESSAGE_NAME = "messageName";
    private String messageName;
    public static final String JSON_PROPERTY_TARGET_PROCESS = "targetProcess";
    private String targetProcess;
    public static final String JSON_PROPERTY_TARGET_FLOW_NODE = "targetFlowNode";
    private String targetFlowNode;
    public static final String JSON_PROPERTY_MESSAGE_CONTENT = "messageContent";
    private Map<String, MessageMessageContent> messageContent = null;
    public static final String JSON_PROPERTY_CORRELATIONS = "correlations";
    private Map<String, MessageMessageContent> correlations = null;

    public Message messageName(String messageName) {
        this.messageName = messageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the message name")
    @JsonProperty(value="messageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public Message targetProcess(String targetProcess) {
        this.targetProcess = targetProcess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the target process name")
    @JsonProperty(value="targetProcess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetProcess() {
        return this.targetProcess;
    }

    public void setTargetProcess(String targetProcess) {
        this.targetProcess = targetProcess;
    }

    public Message targetFlowNode(String targetFlowNode) {
        this.targetFlowNode = targetFlowNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the target FlowNode name")
    @JsonProperty(value="targetFlowNode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetFlowNode() {
        return this.targetFlowNode;
    }

    public void setTargetFlowNode(String targetFlowNode) {
        this.targetFlowNode = targetFlowNode;
    }

    public Message messageContent(Map<String, MessageMessageContent> messageContent) {
        this.messageContent = messageContent;
        return this;
    }

    public Message putMessageContentItem(String key, MessageMessageContent messageContentItem) {
        if (this.messageContent == null) {
            this.messageContent = new HashMap<String, MessageMessageContent>();
        }
        this.messageContent.put(key, messageContentItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the message content")
    @JsonProperty(value="messageContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, MessageMessageContent> getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(Map<String, MessageMessageContent> messageContent) {
        this.messageContent = messageContent;
    }

    public Message correlations(Map<String, MessageMessageContent> correlations) {
        this.correlations = correlations;
        return this;
    }

    public Message putCorrelationsItem(String key, MessageMessageContent correlationsItem) {
        if (this.correlations == null) {
            this.correlations = new HashMap<String, MessageMessageContent>();
        }
        this.correlations.put(key, correlationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the message correlations")
    @JsonProperty(value="correlations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, MessageMessageContent> getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Map<String, MessageMessageContent> correlations) {
        this.correlations = correlations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.messageName, message.messageName) && Objects.equals(this.targetProcess, message.targetProcess) && Objects.equals(this.targetFlowNode, message.targetFlowNode) && Objects.equals(this.messageContent, message.messageContent) && Objects.equals(this.correlations, message.correlations);
    }

    public int hashCode() {
        return Objects.hash(this.messageName, this.targetProcess, this.targetFlowNode, this.messageContent, this.correlations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Message {\n");
        sb.append("    messageName: ").append(this.toIndentedString(this.messageName)).append("\n");
        sb.append("    targetProcess: ").append(this.toIndentedString(this.targetProcess)).append("\n");
        sb.append("    targetFlowNode: ").append(this.toIndentedString(this.targetFlowNode)).append("\n");
        sb.append("    messageContent: ").append(this.toIndentedString(this.messageContent)).append("\n");
        sb.append("    correlations: ").append(this.toIndentedString(this.correlations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

