/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.services.utils.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

class BusinessArchive {
    private static final String PROCESS_DESIGN_FILENAME = "process-design.xml";
    private String processName;
    private String processVersion;
    private File archive;

    static BusinessArchive create(File bar) {
        BusinessArchive businessArchive;
        FileInputStream fileInputStream = new FileInputStream(bar);
        try {
            byte[] fileFromZip = FileUtils.getFileFromZip(fileInputStream, PROCESS_DESIGN_FILENAME);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(new ByteArrayInputStream(fileFromZip));
            doc.getDocumentElement().normalize();
            NamedNodeMap attributes = doc.getFirstChild().getAttributes();
            businessArchive = BusinessArchive.builder().archive(bar).processName(attributes.getNamedItem("name").getNodeValue()).processVersion(attributes.getNamedItem("version").getNodeValue()).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ClientException("Unable to parse bar file", e);
            }
        }
        fileInputStream.close();
        return businessArchive;
    }

    BusinessArchive(String processName, String processVersion, File archive) {
        this.processName = processName;
        this.processVersion = processVersion;
        this.archive = archive;
    }

    public static BusinessArchiveBuilder builder() {
        return new BusinessArchiveBuilder();
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessArchive)) {
            return false;
        }
        BusinessArchive other = (BusinessArchive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$processVersion = this.getProcessVersion();
        String other$processVersion = other.getProcessVersion();
        if (this$processVersion == null ? other$processVersion != null : !this$processVersion.equals(other$processVersion)) {
            return false;
        }
        File this$archive = this.getArchive();
        File other$archive = other.getArchive();
        return !(this$archive == null ? other$archive != null : !((Object)this$archive).equals(other$archive));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessArchive;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $processVersion = this.getProcessVersion();
        result = result * 59 + ($processVersion == null ? 43 : $processVersion.hashCode());
        File $archive = this.getArchive();
        result = result * 59 + ($archive == null ? 43 : ((Object)$archive).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessArchive(processName=" + this.getProcessName() + ", processVersion=" + this.getProcessVersion() + ", archive=" + this.getArchive() + ")";
    }

    public static class BusinessArchiveBuilder {
        private String processName;
        private String processVersion;
        private File archive;

        BusinessArchiveBuilder() {
        }

        public BusinessArchiveBuilder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public BusinessArchiveBuilder processVersion(String processVersion) {
            this.processVersion = processVersion;
            return this;
        }

        public BusinessArchiveBuilder archive(File archive) {
            this.archive = archive;
            return this;
        }

        public BusinessArchive build() {
            return new BusinessArchive(this.processName, this.processVersion, this.archive);
        }

        public String toString() {
            return "BusinessArchive.BusinessArchiveBuilder(processName=" + this.processName + ", processVersion=" + this.processVersion + ", archive=" + this.archive + ")";
        }
    }
}

