/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bonitasoft.web.client.model.License;
import org.bonitasoft.web.client.services.impl.ClientContext;

public class CachingClientContext
implements ClientContext {
    private static final String CONTEXT_LICENSE_KEY = "LICENSE";
    private final Map<String, Object> shareContext = new ConcurrentHashMap<String, Object>();

    @Override
    public License getLicense() {
        return (License)this.shareContext.get(CONTEXT_LICENSE_KEY);
    }

    @Override
    public void setLicense(License license) {
        this.shareContext.put(CONTEXT_LICENSE_KEY, license);
    }

    @Override
    public License getLicense(Function<String, Object> value) {
        return (License)this.shareContext.computeIfAbsent(CONTEXT_LICENSE_KEY, value);
    }

    @Override
    public <T> T get(String key) {
        return (T)this.shareContext.get(key);
    }

    @Override
    public void put(String key, Object o) {
    }

    @Override
    public <T> T remove(String key) {
        if (this.shareContext.containsKey(key)) {
            return (T)this.shareContext.remove(key);
        }
        return null;
    }
}

