/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.bonitasoft.web.client.api.BdmAccessControlApi;
import org.bonitasoft.web.client.api.BdmApi;
import org.bonitasoft.web.client.api.SystemTenantApi;
import org.bonitasoft.web.client.exception.LicenseException;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.BDMAccessControl;
import org.bonitasoft.web.client.model.BDMInstallRequest;
import org.bonitasoft.web.client.model.Bdm;
import org.bonitasoft.web.client.model.TenantPauseRequest;
import org.bonitasoft.web.client.model.TenantResourceState;
import org.bonitasoft.web.client.services.BdmService;
import org.bonitasoft.web.client.services.impl.AbstractService;
import org.bonitasoft.web.client.services.impl.ClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBdmService
extends AbstractService
implements BdmService {
    private static final Logger log = LoggerFactory.getLogger(DefaultBdmService.class);

    public DefaultBdmService(ClientContext clientContext, ApiProvider apiProvider, ObjectMapper objectMapper) {
        super(apiProvider, objectMapper, clientContext);
    }

    @Override
    public void importBDM(File bdm) {
        log.info("Importing Business Data Model file: {}", (Object)bdm.getName());
        log.debug("Pausing tenant ...");
        SystemTenantApi tenantApi = this.apiProvider.get(SystemTenantApi.class);
        tenantApi.updateSystemTenant("1", new TenantPauseRequest().paused("true"));
        log.debug("Tenant paused");
        this.deleteBdmAccessControlIfNeeded();
        BdmApi bdmApi = this.apiProvider.get(BdmApi.class);
        String uploadedFileName = bdmApi.uploadBDM(bdm);
        log.debug("BDM file uploaded");
        bdmApi.installBDM(new BDMInstallRequest().fileUpload(uploadedFileName));
        log.debug("BDM file installed");
        log.debug("Resuming tenant ...");
        tenantApi.updateSystemTenant("1", new TenantPauseRequest().paused("false"));
        log.debug("Tenant Resumed");
        log.info("Business Data Model deployed successfully.");
    }

    @Override
    public void importBdmAccessControl(File accessControl) {
        log.info("Importing BDM AccessControl file: {}", (Object)accessControl.getName());
        this.deleteBdmAccessControlIfNeeded();
        BdmAccessControlApi bdmAccessControlApi = this.apiProvider.get(BdmAccessControlApi.class);
        String uploadedFileName = bdmAccessControlApi.uploadBDMAccessControl(accessControl);
        log.debug("BDM Access Control file uploaded");
        bdmAccessControlApi.importBDMAccessControl(uploadedFileName);
        log.debug("BDM Access Control file installed");
        log.info("BDM AccessControl file imported successfully");
    }

    private void deleteBdmAccessControlIfNeeded() {
        if (!this.isCommunity() && TenantResourceState.INSTALLED.equals((Object)this.getBdmAccessControlStatus().getState())) {
            log.debug("Deleting previous BdmAccessControl ...");
            BdmAccessControlApi accessControlApi = this.apiProvider.get(BdmAccessControlApi.class);
            accessControlApi.deleteBDMAccessControl();
            log.debug("Previous BdmAccessControl deleted");
        }
    }

    @Override
    public Bdm getBdmStatus() {
        log.info("Get BDM status");
        BdmApi bdmApi = this.apiProvider.get(BdmApi.class);
        Bdm bdm = bdmApi.getBdm();
        log.debug("BDM status: {}", (Object)bdm);
        return bdm;
    }

    @Override
    public BDMAccessControl getBdmAccessControlStatus() {
        log.info("Get BDM AccessControl status");
        if (this.isCommunity()) {
            String message = "BDM AccessControl management skipped: your current Bonita license is 'Community' and this feature is only supported in 'Subscription' editions.";
            throw new LicenseException(message);
        }
        BdmAccessControlApi accessControlApi = this.apiProvider.get(BdmAccessControlApi.class);
        BDMAccessControl bdmAccessControlStatus = accessControlApi.getBDMAccessControlStatus();
        log.debug("BDM status: {}", (Object)bdmAccessControlStatus);
        return bdmAccessControlStatus;
    }
}

