/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"token", "applicationId", "pageId"})
public class ApplicationPageCreateRequest
implements Serializable {
    public static final String JSON_PROPERTY_TOKEN = "token";
    public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
    public static final String JSON_PROPERTY_PAGE_ID = "pageId";
    private static final long serialVersionUID = 1L;
    private String token;
    private String applicationId;
    private String pageId;

    public ApplicationPageCreateRequest token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="token use to access the page using a URL : ../appName/pageToken/")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public ApplicationPageCreateRequest applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the application related to this page")
    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ApplicationPageCreateRequest pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the custom page to display")
    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageId() {
        return this.pageId;
    }

    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPageCreateRequest applicationPageCreateRequest = (ApplicationPageCreateRequest)o;
        return Objects.equals(this.token, applicationPageCreateRequest.token) && Objects.equals(this.applicationId, applicationPageCreateRequest.applicationId) && Objects.equals(this.pageId, applicationPageCreateRequest.pageId);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.applicationId, this.pageId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationPageCreateRequest {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

