/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This resource enables you to retrieve the value of a specific archived variable name for a specific case (or process instance). Only persistent variables are concerned by this resource, not transient variables.")
@JsonPropertyOrder(value={"name", "description", "type", "containerId", "containerType", "value", "archivedDate", "sourcedObjectId"})
public class ArchivedActivityVariable
implements Serializable {
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    public static final String JSON_PROPERTY_TYPE = "type";
    public static final String JSON_PROPERTY_CONTAINER_ID = "containerId";
    public static final String JSON_PROPERTY_CONTAINER_TYPE = "containerType";
    public static final String JSON_PROPERTY_VALUE = "value";
    public static final String JSON_PROPERTY_ARCHIVED_DATE = "archivedDate";
    public static final String JSON_PROPERTY_SOURCED_OBJECT_ID = "sourcedObjectId";
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String type;
    private String containerId;
    private String containerType;
    private String value;
    private String archivedDate;
    private String sourcedObjectId;

    public ArchivedActivityVariable name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the archived  activity variable")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ArchivedActivityVariable description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The description of the variable if any")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ArchivedActivityVariable type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fully qualified class name of the variable type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public ArchivedActivityVariable containerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the activity containing this variable (same as the one passed as parameter)")
    @JsonProperty(value="containerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerId() {
        return this.containerId;
    }

    @JsonProperty(value="containerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public ArchivedActivityVariable containerType(String containerType) {
        this.containerType = containerType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ACTIVITY_INSTANCE")
    @JsonProperty(value="containerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerType() {
        return this.containerType;
    }

    @JsonProperty(value="containerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public ArchivedActivityVariable value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the value of this variable. The format of the value depends on the type of the variable")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public ArchivedActivityVariable archivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when this variable was archived. The date format is yyyy-MM-dd HH:mm:ss.SSS")
    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchivedDate() {
        return this.archivedDate;
    }

    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
    }

    public ArchivedActivityVariable sourcedObjectId(String sourcedObjectId) {
        this.sourcedObjectId = sourcedObjectId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity variable before it was archived")
    @JsonProperty(value="sourcedObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourcedObjectId() {
        return this.sourcedObjectId;
    }

    @JsonProperty(value="sourcedObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcedObjectId(String sourcedObjectId) {
        this.sourcedObjectId = sourcedObjectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedActivityVariable archivedActivityVariable = (ArchivedActivityVariable)o;
        return Objects.equals(this.name, archivedActivityVariable.name) && Objects.equals(this.description, archivedActivityVariable.description) && Objects.equals(this.type, archivedActivityVariable.type) && Objects.equals(this.containerId, archivedActivityVariable.containerId) && Objects.equals(this.containerType, archivedActivityVariable.containerType) && Objects.equals(this.value, archivedActivityVariable.value) && Objects.equals(this.archivedDate, archivedActivityVariable.archivedDate) && Objects.equals(this.sourcedObjectId, archivedActivityVariable.sourcedObjectId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.containerId, this.containerType, this.value, this.archivedDate, this.sourcedObjectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchivedActivityVariable {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    containerId: ").append(this.toIndentedString(this.containerId)).append("\n");
        sb.append("    containerType: ").append(this.toIndentedString(this.containerType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("    sourcedObjectId: ").append(this.toIndentedString(this.sourcedObjectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

