/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"parentMenuId", "applicationPageId", "applicationId", "menuIndex", "displayName"})
@JsonTypeName(value="ApplicationMenuUpdateRequest")
public class ApplicationMenuUpdateRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PARENT_MENU_ID = "parentMenuId";
    private String parentMenuId;
    public static final String JSON_PROPERTY_APPLICATION_PAGE_ID = "applicationPageId";
    private String applicationPageId;
    public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
    private String applicationId;
    public static final String JSON_PROPERTY_MENU_INDEX = "menuIndex";
    private String menuIndex;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public ApplicationMenuUpdateRequest parentMenuId(String parentMenuId) {
        this.parentMenuId = parentMenuId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the parent menu of this menu item, or -1 for a top-level item")
    @JsonProperty(value="parentMenuId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentMenuId() {
        return this.parentMenuId;
    }

    public void setParentMenuId(String parentMenuId) {
        this.parentMenuId = parentMenuId;
    }

    public ApplicationMenuUpdateRequest applicationPageId(String applicationPageId) {
        this.applicationPageId = applicationPageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the application page targeted by this menu item, or -1 if there is no targeted page (that is, the item is a parent menu)")
    @JsonProperty(value="applicationPageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApplicationPageId() {
        return this.applicationPageId;
    }

    public void setApplicationPageId(String applicationPageId) {
        this.applicationPageId = applicationPageId;
    }

    public ApplicationMenuUpdateRequest applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the application related to this menu item")
    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ApplicationMenuUpdateRequest menuIndex(String menuIndex) {
        this.menuIndex = menuIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="index of the menu item")
    @JsonProperty(value="menuIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMenuIndex() {
        return this.menuIndex;
    }

    public void setMenuIndex(String menuIndex) {
        this.menuIndex = menuIndex;
    }

    public ApplicationMenuUpdateRequest displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="label to display for this menu in the application navigation bar or menu")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationMenuUpdateRequest applicationMenuUpdateRequest = (ApplicationMenuUpdateRequest)o;
        return Objects.equals(this.parentMenuId, applicationMenuUpdateRequest.parentMenuId) && Objects.equals(this.applicationPageId, applicationMenuUpdateRequest.applicationPageId) && Objects.equals(this.applicationId, applicationMenuUpdateRequest.applicationId) && Objects.equals(this.menuIndex, applicationMenuUpdateRequest.menuIndex) && Objects.equals(this.displayName, applicationMenuUpdateRequest.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.parentMenuId, this.applicationPageId, this.applicationId, this.menuIndex, this.displayName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationMenuUpdateRequest {\n");
        sb.append("    parentMenuId: ").append(this.toIndentedString(this.parentMenuId)).append("\n");
        sb.append("    applicationPageId: ").append(this.toIndentedString(this.applicationPageId)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    menuIndex: ").append(this.toIndentedString(this.menuIndex)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

