/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"message", "exception", "explanations"})
@JsonTypeName(value="Error")
public class Error
extends HashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_EXCEPTION = "exception";
    private String exception;
    public static final String JSON_PROPERTY_EXPLANATIONS = "explanations";
    private List<String> explanations = null;

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The error message")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error exception(String exception) {
        this.exception = exception;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exception type")
    @JsonProperty(value="exception")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public Error explanations(List<String> explanations) {
        this.explanations = explanations;
        return this;
    }

    public Error addExplanationsItem(String explanationsItem) {
        if (this.explanations == null) {
            this.explanations = new ArrayList<String>();
        }
        this.explanations.add(explanationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Further details on the error")
    @JsonProperty(value="explanations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExplanations() {
        return this.explanations;
    }

    public void setExplanations(List<String> explanations) {
        this.explanations = explanations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.message, error.message) && Objects.equals(this.exception, error.exception) && Objects.equals(this.explanations, error.explanations) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.message, this.exception, this.explanations, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    exception: ").append(this.toIndentedString(this.exception)).append("\n");
        sb.append("    explanations: ").append(this.toIndentedString(this.explanations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

