/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Form Mapping specifies the mapping of a form to a process or a task. The mapping indicates the technology used to create the form, in the `target` attribute.")
@JsonPropertyOrder(value={"id", "processDefinitionId", "type", "target", "task", "pageId", "pageMappingKey", "lastUpdateBy", "lastUpdateDate", "url"})
@JsonTypeName(value="FormMapping")
public class FormMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private String processDefinitionId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_TARGET = "target";
    private TargetEnum target;
    public static final String JSON_PROPERTY_TASK = "task";
    private String task;
    public static final String JSON_PROPERTY_PAGE_ID = "pageId";
    private String pageId;
    public static final String JSON_PROPERTY_PAGE_MAPPING_KEY = "pageMappingKey";
    private String pageMappingKey;
    public static final String JSON_PROPERTY_LAST_UPDATE_BY = "lastUpdateBy";
    private String lastUpdateBy;
    public static final String JSON_PROPERTY_LAST_UPDATE_DATE = "lastUpdateDate";
    private String lastUpdateDate;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public FormMapping id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the form mapping identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FormMapping processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the process identifier related to this form mapping")
    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public FormMapping type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the form mapping type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FormMapping target(TargetEnum target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the target")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TargetEnum getTarget() {
        return this.target;
    }

    public void setTarget(TargetEnum target) {
        this.target = target;
    }

    public FormMapping task(String task) {
        this.task = task;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the task name when type is TASK - null otherwise")
    @JsonProperty(value="task")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public FormMapping pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the custom page identifier when type is INTERNAL - null otherwise")
    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public FormMapping pageMappingKey(String pageMappingKey) {
        this.pageMappingKey = pageMappingKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the page mapping key part used to generate the form URL")
    @JsonProperty(value="pageMappingKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageMappingKey() {
        return this.pageMappingKey;
    }

    public void setPageMappingKey(String pageMappingKey) {
        this.pageMappingKey = pageMappingKey;
    }

    public FormMapping lastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the identifier of the user who last updated this form mapping - 0 if no update has been done yet")
    @JsonProperty(value="lastUpdateBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public FormMapping lastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the last update date in milliseconds - null if no update has been done yet")
    @JsonProperty(value="lastUpdateDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public FormMapping url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the external URL (string) when type is URL - null otherwise")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormMapping formMapping = (FormMapping)o;
        return Objects.equals(this.id, formMapping.id) && Objects.equals(this.processDefinitionId, formMapping.processDefinitionId) && Objects.equals((Object)this.type, (Object)formMapping.type) && Objects.equals((Object)this.target, (Object)formMapping.target) && Objects.equals(this.task, formMapping.task) && Objects.equals(this.pageId, formMapping.pageId) && Objects.equals(this.pageMappingKey, formMapping.pageMappingKey) && Objects.equals(this.lastUpdateBy, formMapping.lastUpdateBy) && Objects.equals(this.lastUpdateDate, formMapping.lastUpdateDate) && Objects.equals(this.url, formMapping.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.processDefinitionId, this.type, this.target, this.task, this.pageId, this.pageMappingKey, this.lastUpdateBy, this.lastUpdateDate, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormMapping {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    target: ").append(this.toIndentedString((Object)this.target)).append("\n");
        sb.append("    task: ").append(this.toIndentedString(this.task)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    pageMappingKey: ").append(this.toIndentedString(this.pageMappingKey)).append("\n");
        sb.append("    lastUpdateBy: ").append(this.toIndentedString(this.lastUpdateBy)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TargetEnum {
        URL("URL"),
        INTERNAL("INTERNAL"),
        LEGACY("LEGACY"),
        UNDEFINED("UNDEFINED"),
        NONE("NONE");

        private String value;

        private TargetEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TargetEnum fromValue(String value) {
            for (TargetEnum b : TargetEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        PROCESSSTART("PROCESSSTART"),
        PROCESSOVERVIEW("PROCESSOVERVIEW"),
        TASK("TASK");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

