/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A document in an active case")
@JsonPropertyOrder(value={"id", "creationDate", "author", "index", "contentMimetype", "caseId", "contentStorageId", "isInternal", "description", "name", "fileName", "submittedBy", "url", "version"})
@JsonTypeName(value="ProcessInstanceDocument")
public class ProcessInstanceDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private String creationDate;
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private String author;
    public static final String JSON_PROPERTY_INDEX = "index";
    private String index;
    public static final String JSON_PROPERTY_CONTENT_MIMETYPE = "contentMimetype";
    private String contentMimetype;
    public static final String JSON_PROPERTY_CASE_ID = "caseId";
    private String caseId;
    public static final String JSON_PROPERTY_CONTENT_STORAGE_ID = "contentStorageId";
    private String contentStorageId;
    public static final String JSON_PROPERTY_IS_INTERNAL = "isInternal";
    private Boolean isInternal;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName;
    public static final String JSON_PROPERTY_SUBMITTED_BY = "submittedBy";
    private String submittedBy;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public ProcessInstanceDocument id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="documentId")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessInstanceDocument creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="date and time")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public ProcessInstanceDocument author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="submittorUserId")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ProcessInstanceDocument index(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="index in a list of documents, or -1 for a single document")
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public ProcessInstanceDocument contentMimetype(String contentMimetype) {
        this.contentMimetype = contentMimetype;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MIME type")
    @JsonProperty(value="contentMimetype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentMimetype() {
        return this.contentMimetype;
    }

    public void setContentMimetype(String contentMimetype) {
        this.contentMimetype = contentMimetype;
    }

    public ProcessInstanceDocument caseId(String caseId) {
        this.caseId = caseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="caseId")
    @JsonProperty(value="caseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public ProcessInstanceDocument contentStorageId(String contentStorageId) {
        this.contentStorageId = contentStorageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="storageId")
    @JsonProperty(value="contentStorageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentStorageId() {
        return this.contentStorageId;
    }

    public void setContentStorageId(String contentStorageId) {
        this.contentStorageId = contentStorageId;
    }

    public ProcessInstanceDocument isInternal(Boolean isInternal) {
        this.isInternal = isInternal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` if  the the document object contains the content directly. `false` if the document is specified by URL so the document object contains a reference to the content, not the content itself.")
    @JsonProperty(value="isInternal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsInternal() {
        return this.isInternal;
    }

    public void setIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
    }

    public ProcessInstanceDocument description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessInstanceDocument name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessInstanceDocument fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="filename")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ProcessInstanceDocument submittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="submittorUserId")
    @JsonProperty(value="submittedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public ProcessInstanceDocument url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="urlForDownload")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ProcessInstanceDocument version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="version")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceDocument processInstanceDocument = (ProcessInstanceDocument)o;
        return Objects.equals(this.id, processInstanceDocument.id) && Objects.equals(this.creationDate, processInstanceDocument.creationDate) && Objects.equals(this.author, processInstanceDocument.author) && Objects.equals(this.index, processInstanceDocument.index) && Objects.equals(this.contentMimetype, processInstanceDocument.contentMimetype) && Objects.equals(this.caseId, processInstanceDocument.caseId) && Objects.equals(this.contentStorageId, processInstanceDocument.contentStorageId) && Objects.equals(this.isInternal, processInstanceDocument.isInternal) && Objects.equals(this.description, processInstanceDocument.description) && Objects.equals(this.name, processInstanceDocument.name) && Objects.equals(this.fileName, processInstanceDocument.fileName) && Objects.equals(this.submittedBy, processInstanceDocument.submittedBy) && Objects.equals(this.url, processInstanceDocument.url) && Objects.equals(this.version, processInstanceDocument.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.creationDate, this.author, this.index, this.contentMimetype, this.caseId, this.contentStorageId, this.isInternal, this.description, this.name, this.fileName, this.submittedBy, this.url, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceDocument {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    contentMimetype: ").append(this.toIndentedString(this.contentMimetype)).append("\n");
        sb.append("    caseId: ").append(this.toIndentedString(this.caseId)).append("\n");
        sb.append("    contentStorageId: ").append(this.toIndentedString(this.contentStorageId)).append("\n");
        sb.append("    isInternal: ").append(this.toIndentedString(this.isInternal)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    submittedBy: ").append(this.toIndentedString(this.submittedBy)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

