/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bonitasoft.web.client.model.ProcessInstanceInfoFlowNodeStatesCounters;

@ApiModel(description="Retrieves information about a process instances. It returns counters for each flow node in the process instances, showing the number of flow node instances that are in completed, ready, or failed state. If there are no flow node instances in a given state, no counter is returned for that state for the flow node.")
@JsonPropertyOrder(value={"id", "flowNodeStatesCounters"})
@JsonTypeName(value="ProcessInstanceInfo")
public class ProcessInstanceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_FLOW_NODE_STATES_COUNTERS = "flowNodeStatesCounters";
    private Map<String, ProcessInstanceInfoFlowNodeStatesCounters> flowNodeStatesCounters = null;

    public ProcessInstanceInfo id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="case identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessInstanceInfo flowNodeStatesCounters(Map<String, ProcessInstanceInfoFlowNodeStatesCounters> flowNodeStatesCounters) {
        this.flowNodeStatesCounters = flowNodeStatesCounters;
        return this;
    }

    public ProcessInstanceInfo putFlowNodeStatesCountersItem(String key, ProcessInstanceInfoFlowNodeStatesCounters flowNodeStatesCountersItem) {
        if (this.flowNodeStatesCounters == null) {
            this.flowNodeStatesCounters = new HashMap<String, ProcessInstanceInfoFlowNodeStatesCounters>();
        }
        this.flowNodeStatesCounters.put(key, flowNodeStatesCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="flow nodes counters")
    @JsonProperty(value="flowNodeStatesCounters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, ProcessInstanceInfoFlowNodeStatesCounters> getFlowNodeStatesCounters() {
        return this.flowNodeStatesCounters;
    }

    public void setFlowNodeStatesCounters(Map<String, ProcessInstanceInfoFlowNodeStatesCounters> flowNodeStatesCounters) {
        this.flowNodeStatesCounters = flowNodeStatesCounters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceInfo processInstanceInfo = (ProcessInstanceInfo)o;
        return Objects.equals(this.id, processInstanceInfo.id) && Objects.equals(this.flowNodeStatesCounters, processInstanceInfo.flowNodeStatesCounters);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.flowNodeStatesCounters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    flowNodeStatesCounters: ").append(this.toIndentedString(this.flowNodeStatesCounters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

