/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bonitasoft.web.client.api.ProcessApi;
import org.bonitasoft.web.client.api.ProcessParameterApi;
import org.bonitasoft.web.client.api.ProcessResolutionProblemApi;
import org.bonitasoft.web.client.api.UserTaskApi;
import org.bonitasoft.web.client.exception.NotFoundException;
import org.bonitasoft.web.client.exception.process.DuplicatedProcessException;
import org.bonitasoft.web.client.exception.process.ProcessActivationException;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.ActivationState;
import org.bonitasoft.web.client.model.ConfigurationState;
import org.bonitasoft.web.client.model.ProcessCreateRequest;
import org.bonitasoft.web.client.model.ProcessDefinition;
import org.bonitasoft.web.client.model.ProcessInstantiationResponse;
import org.bonitasoft.web.client.model.ProcessParameter;
import org.bonitasoft.web.client.model.ProcessResolutionProblem;
import org.bonitasoft.web.client.model.ProcessUpdateRequest;
import org.bonitasoft.web.client.model.UserTask;
import org.bonitasoft.web.client.model.UserTaskUpdateRequest;
import org.bonitasoft.web.client.services.ProcessService;
import org.bonitasoft.web.client.services.impl.BusinessArchiveInfo;
import org.bonitasoft.web.client.services.impl.base.AbstractService;
import org.bonitasoft.web.client.services.impl.base.ClientContext;
import org.bonitasoft.web.client.services.policies.ProcessImportPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessService
extends AbstractService
implements ProcessService {
    private static final Logger log = LoggerFactory.getLogger(DefaultProcessService.class);

    public DefaultProcessService(ClientContext clientContext, ApiProvider apiProvider, ObjectMapper objectMapper) {
        super(apiProvider, objectMapper, clientContext);
    }

    @Override
    public void importProcess(File barFile, ProcessImportPolicy policy) {
        log.info("Deploying process '{}' using policy {} ...", (Object)barFile.getName(), (Object)policy.name());
        BusinessArchiveInfo barInfo = BusinessArchiveInfo.readFrom(barFile);
        Optional<ProcessDefinition> process = this.getProcess(barInfo.getProcessName(), barInfo.getProcessVersion());
        if (process.isPresent()) {
            log.debug("Process '{}' in version '{}' already exists.", (Object)barInfo.getProcessName(), (Object)barInfo.getProcessVersion());
            switch (policy) {
                case REPLACE_DUPLICATES: {
                    log.debug("Policy REPLACE_DUPLICATES: deleting existing process...");
                    this.deleteExistingProcess(process.get());
                    break;
                }
                case IGNORE_DUPLICATES: {
                    log.debug("Policy IGNORE_DUPLICATES: skip deployment of existing process.");
                    return;
                }
                default: {
                    throw new DuplicatedProcessException(barInfo.getProcessName(), barInfo.getProcessVersion(), "Policy FAIL_ON_DUPLICATES: deployment aborted.");
                }
            }
        }
        ProcessApi processApi = this.apiProvider.get(ProcessApi.class);
        log.debug("Uploading process file...");
        String uploadedFileName = processApi.uploadProcess(barFile);
        log.debug("Process file uploaded successfully.");
        ProcessDefinition processDeployed = processApi.createProcess(new ProcessCreateRequest().fileupload(uploadedFileName));
        log.info("Process {}-{} deployed successfully.", (Object)processDeployed.getName(), (Object)processDeployed.getVersion());
        if (!ConfigurationState.RESOLVED.equals((Object)processDeployed.getConfigurationState())) {
            throw new ProcessActivationException("Process is unresolved, maybe some process parameters have not been configured yet.", barInfo.getProcessName(), barInfo.getProcessVersion());
        }
        log.info("Process {}-{} is resolved. Activating process...", (Object)barInfo.getProcessName(), (Object)barInfo.getProcessVersion());
        String processId = processDeployed.getId();
        processApi.updateProcessById(processId, new ProcessUpdateRequest().activationState(ActivationState.ENABLED));
        log.info("Process activated successfully.");
    }

    private void deleteExistingProcess(ProcessDefinition process) {
        ProcessApi processApi = this.apiProvider.get(ProcessApi.class);
        if (ActivationState.ENABLED.equals((Object)process.getActivationState())) {
            log.info("Deactivating existing process {}-{} before deletion...", (Object)process.getName(), (Object)process.getVersion());
            processApi.updateProcessById(process.getId(), new ProcessUpdateRequest().activationState(ActivationState.DISABLED));
            log.info("Existing process {}-{} deactivated.", (Object)process.getName(), (Object)process.getVersion());
        }
        processApi.deleteProcessById(process.getId());
        log.info("Existing process {}-{} deleted.", (Object)process.getName(), (Object)process.getVersion());
    }

    @Override
    public Optional<ProcessDefinition> getProcess(String name, String version) {
        log.info("Get process '{}' with version '{}'", (Object)name, (Object)version);
        List<ProcessDefinition> processes = this.apiProvider.get(ProcessApi.class).searchProcesses(new ProcessApi.SearchProcessesQueryParams().p(0).c(1).f(Arrays.asList("name=" + name, "version=" + version)));
        if (processes.isEmpty()) {
            log.debug("Can't find any existing process with name '{}' and version '{}'.", (Object)name, (Object)version);
            return Optional.empty();
        }
        log.debug("Process '{}' with version '{}' found successfully.", (Object)name, (Object)version);
        return processes.stream().findFirst();
    }

    @Override
    public List<ProcessDefinition> searchProcesses(int page, int count) {
        return this.searchProcesses(new ProcessApi.SearchProcessesQueryParams().p(page).c(count));
    }

    @Override
    public List<ProcessDefinition> searchProcesses(ProcessApi.SearchProcessesQueryParams params) {
        log.info("Search processes with params {}", (Object)params);
        return this.apiProvider.get(ProcessApi.class).searchProcesses(params);
    }

    @Override
    public List<ProcessParameter> searchProcessParameters(int page, int count, String processId) {
        log.info("Search process parameters for process {} with params: p={},c={}", new Object[]{processId, page, count});
        return this.apiProvider.get(ProcessParameterApi.class).searchProcessParameters(new ProcessParameterApi.SearchProcessParametersQueryParams().p(page).c(count).f(Collections.singletonList("process_id=" + processId)));
    }

    @Override
    public List<ProcessResolutionProblem> getProcessProblem(int page, int count, String processId) {
        log.info("Search process problems for process {} with params: p={},c={}", new Object[]{processId, page, count});
        return this.apiProvider.get(ProcessResolutionProblemApi.class).searchProcessResolutionProblems(new ProcessResolutionProblemApi.SearchProcessResolutionProblemsQueryParams().p(page).c(count).f(Collections.singletonList("process_id=" + processId)));
    }

    @Override
    public ProcessInstantiationResponse startProcess(String name, String version) {
        return this.getProcess(name, version).map(p -> this.startProcess(p.getId())).orElseThrow(() -> new NotFoundException(String.format("No process found for name '%s' and version '%s'", name, version)));
    }

    @Override
    public ProcessInstantiationResponse startProcess(String id) {
        return this.startProcess(id, new HashMap<String, Object>());
    }

    @Override
    public ProcessInstantiationResponse startProcess(String id, Map<String, Object> params) {
        log.info("Start process {} with params {}", (Object)id, params);
        return this.apiProvider.get(ProcessApi.class).instanciateProcess(id, params);
    }

    @Override
    public UserTask getUserTask(String taskId) {
        log.info("Get User Task {}", (Object)taskId);
        return Optional.ofNullable(this.apiProvider.get(UserTaskApi.class).getUserTaskById(taskId)).map(userTask -> {
            log.debug("Found successfully User Task: {}", userTask);
            return userTask;
        }).orElseThrow(() -> new NotFoundException("No user task found for id: " + taskId));
    }

    @Override
    public List<UserTask> searchUserTask(String rootContainerId) {
        log.info("Search User Task for process instance {}", (Object)rootContainerId);
        List<UserTask> userTasks = this.apiProvider.get(UserTaskApi.class).searchUserTasks(new UserTaskApi.SearchUserTasksQueryParams().f(Collections.singletonList("rootContainerId=" + rootContainerId)));
        log.debug("Found User Tasks: {}", userTasks);
        return userTasks;
    }

    @Override
    public void assignUserTask(String taskId, String assignedUserId) {
        this.assignUserTask(taskId, assignedUserId, null);
    }

    @Override
    public void assignUserTask(String taskId, String assignedUserId, String state) {
        log.info("Updating User Task {}. Assigned to {} in state {}", new Object[]{taskId, assignedUserId, state});
        UserTaskUpdateRequest params = new UserTaskUpdateRequest().assignedId(assignedUserId);
        if (state != null) {
            params.setState(state);
        }
        this.apiProvider.get(UserTaskApi.class).updateUserTaskById(taskId, params);
        log.info("User Task {} updated", (Object)taskId);
    }

    @Override
    public void executeUserTask(String taskId) {
        this.executeUserTask(taskId, new HashMap<String, Object>());
    }

    @Override
    public void executeUserTask(String taskId, Map<String, Object> contractData) {
        log.info("Executing User Task {} with parameters {}", (Object)taskId, contractData);
        this.apiProvider.get(UserTaskApi.class).executeUserTask(taskId, contractData, false);
        log.info("User Task {} executed", (Object)taskId);
    }
}

