/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.web.client.api.OrganizationApi;
import org.bonitasoft.web.client.api.ProfileApi;
import org.bonitasoft.web.client.api.ProfileMemberApi;
import org.bonitasoft.web.client.api.RoleApi;
import org.bonitasoft.web.client.api.UserApi;
import org.bonitasoft.web.client.exception.LicenseException;
import org.bonitasoft.web.client.exception.NotFoundException;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.Profile;
import org.bonitasoft.web.client.model.ProfileMember;
import org.bonitasoft.web.client.model.ProfileMemberCreateRequest;
import org.bonitasoft.web.client.model.Role;
import org.bonitasoft.web.client.model.User;
import org.bonitasoft.web.client.model.UserCreateRequest;
import org.bonitasoft.web.client.services.UserService;
import org.bonitasoft.web.client.services.impl.base.AbstractService;
import org.bonitasoft.web.client.services.impl.base.ClientContext;
import org.bonitasoft.web.client.services.impl.xml.XmlDocumentParser;
import org.bonitasoft.web.client.services.policies.OrganizationImportPolicy;
import org.bonitasoft.web.client.services.policies.ProfileImportPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultUserService
extends AbstractService
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);

    public DefaultUserService(ClientContext clientContext, ApiProvider apiProvider, ObjectMapper objectMapper) {
        super(apiProvider, objectMapper, clientContext);
    }

    @Override
    public void importOrganization(File organization, OrganizationImportPolicy policy) {
        log.info("Importing organization file: {} with policy: {}", (Object)organization.getName(), (Object)policy);
        OrganizationApi organizationApi = this.apiProvider.get(OrganizationApi.class);
        String uploadedFileName = organizationApi.uploadOrganization(organization);
        log.debug("Organization file uploaded");
        organizationApi.importOrganization(uploadedFileName, policy.name());
        log.debug("Organization file installed");
        log.info("Organization file imported successfully");
    }

    @Override
    public User getUser(String username) {
        log.info("Get user with username: {}", (Object)username);
        UserApi userApi = this.apiProvider.get(UserApi.class);
        List<String> filter = Collections.singletonList("userName=" + username);
        return (User)userApi.searchUsers(new UserApi.SearchUsersQueryParams().p(0).c(1).f(filter)).stream().findFirst().orElseThrow(() -> new NotFoundException("No user found for the username: " + username));
    }

    @Override
    public User createUser(UserCreateRequest userCreateRequest) {
        log.info("Create user with params: {}", (Object)userCreateRequest);
        UserApi userApi = this.apiProvider.get(UserApi.class);
        return userApi.createUser(userCreateRequest);
    }

    @Override
    public List<User> searchUsers(UserApi.SearchUsersQueryParams params) {
        log.info("Search users with params: {}", (Object)params);
        UserApi userApi = this.apiProvider.get(UserApi.class);
        return userApi.searchUsers(params);
    }

    @Override
    public void importProfiles(File profiles, ProfileImportPolicy policy) {
        if (this.isCommunity()) {
            String message = String.format("Profile import of %s file skipped: your current Bonita license is 'Community' and this feature is only supported in 'Subscription' editions.", profiles.getName());
            throw new LicenseException(message);
        }
        log.info("Importing profiles from {} with {}...", (Object)profiles.getName(), (Object)policy);
        if (ProfileImportPolicy.IGNORE_IF_ANY_EXISTS.equals((Object)policy)) {
            List<String> profilesToDeployNames = this.getProfilesNames(profiles);
            if (this.anyProfileExist(profilesToDeployNames)) {
                return;
            }
            policy = ProfileImportPolicy.REPLACE_DUPLICATES;
        }
        ProfileApi profileApi = this.apiProvider.get(ProfileApi.class);
        log.debug("Uploading profiles file...");
        String uploadedFileName = profileApi.uploadprofiles(profiles);
        log.debug("Installing profiles file...");
        profileApi.importProfiles(uploadedFileName, policy.name());
        log.info("Profiles imported");
    }

    protected boolean anyProfileExist(List<String> profilesNames) {
        ArrayList<String> existingProfiles = new ArrayList<String>();
        for (String profileName : profilesNames) {
            try {
                Profile profile = this.getProfileByName(profileName);
                existingProfiles.add(profile.getName());
            }
            catch (NotFoundException notFoundException) {}
        }
        return !existingProfiles.isEmpty();
    }

    protected List<String> getProfilesNames(File profiles) {
        ArrayList<String> tokens = new ArrayList<String>();
        XmlDocumentParser documentParser = new XmlDocumentParser();
        Document doc = documentParser.parse(profiles);
        NodeList nodeList = documentParser.queryNodeList(doc, "/profiles/profile/@name");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            tokens.add(item.getNodeValue());
        }
        return tokens;
    }

    @Override
    public List<Profile> searchProfiles(int page, int count) {
        ProfileApi.SearchProfilesQueryParams params = new ProfileApi.SearchProfilesQueryParams().p(page).c(count).o("name ASC");
        return this.searchProfiles(params);
    }

    @Override
    public Role getRoleByName(String name) {
        return (Role)this.searchRoles(new RoleApi.SearchRolesQueryParams().p(0).c(1).f(Collections.singletonList("name=" + name))).stream().findFirst().orElseThrow(() -> new NotFoundException("Role with name '" + name + "' not found"));
    }

    @Override
    public Profile getProfileByName(String name) {
        return (Profile)this.searchProfiles(new ProfileApi.SearchProfilesQueryParams().p(0).c(1).f(Collections.singletonList("name=" + name))).stream().findFirst().orElseThrow(() -> new NotFoundException("Profile with name  '" + name + "' not found"));
    }

    @Override
    public List<Role> searchRoles(RoleApi.SearchRolesQueryParams params) {
        log.info("Search roles with params: {}", (Object)params);
        return this.apiProvider.get(RoleApi.class).searchRoles(params);
    }

    @Override
    public List<Profile> searchProfiles(ProfileApi.SearchProfilesQueryParams params) {
        log.info("Search profiles with params: {}", (Object)params);
        return this.apiProvider.get(ProfileApi.class).searchProfiles(params);
    }

    @Override
    public String addUserToProfile(String userId, String profileId) {
        log.info("Add user {} to profile {}...", (Object)userId, (Object)profileId);
        ProfileMemberApi profileMemberApi = this.apiProvider.get(ProfileMemberApi.class);
        ProfileMember profileMember = profileMemberApi.createProfileMember(new ProfileMemberCreateRequest().memberType(ProfileMemberCreateRequest.MemberTypeEnum.USER).userId(userId).profileId(profileId));
        log.info("User membership added to profile {}. Membership: {}", (Object)profileId, (Object)profileMember);
        return profileMember.getId();
    }

    @Override
    public String addRoleToProfile(String roleId, String profileId) {
        log.info("Add role {} to profile {}...", (Object)roleId, (Object)profileId);
        ProfileMemberApi profileMemberApi = this.apiProvider.get(ProfileMemberApi.class);
        ProfileMember profileMember = profileMemberApi.createProfileMember(new ProfileMemberCreateRequest().memberType(ProfileMemberCreateRequest.MemberTypeEnum.ROLE).roleId(roleId).profileId(profileId));
        log.info("Role membership added to profile {}. Membership: {}", (Object)profileId, (Object)profileMember);
        return profileMember.getId();
    }

    @Override
    public String addUserToProfileByNames(String username, String profileName) {
        User user = this.getUser(username);
        Profile profile = this.getProfileByName(profileName);
        return this.addUserToProfile(user.getId(), profile.getId());
    }
}

