/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bonitasoft.web.client.exception.ClientException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlDocumentParser {
    private final DocumentBuilder documentBuilder;

    public XmlDocumentParser() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        documentBuilderFactory.setNamespaceAware(false);
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ClientException("Failed to create xml parser", e);
        }
    }

    public Document parse(File xmlFile) {
        try {
            Document document = this.documentBuilder.parse(xmlFile);
            document.getDocumentElement().normalize();
            return document;
        }
        catch (IOException | SAXException e) {
            throw new ClientException("Failed to read xml document", e);
        }
    }

    public Document parse(byte[] doc) {
        try {
            Document document = this.documentBuilder.parse(new ByteArrayInputStream(doc));
            document.getDocumentElement().normalize();
            return document;
        }
        catch (IOException | SAXException e) {
            throw new ClientException("Failed to read xml document", e);
        }
    }

    public NodeList queryNodeList(Document document, String query) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression compile = xPath.compile(query);
            return (NodeList)compile.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ClientException("Failed to query xml node from file: " + query, e);
        }
    }
}

