/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.invoker;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.invoker.StringUtil;

public final class EncodingUtils {
    private EncodingUtils() {
    }

    public static Object encodeCollection(Collection<?> parameters, String collectionFormat) {
        if (parameters == null) {
            return parameters;
        }
        ArrayList<String> stringValues = new ArrayList<String>(parameters.size());
        for (Object parameter : parameters) {
            if (parameter == null) continue;
            stringValues.add(EncodingUtils.encode(parameter));
        }
        if (stringValues.size() < 2 || "multi".equals(collectionFormat)) {
            return stringValues;
        }
        String[] stringArray = stringValues.toArray(new String[0]);
        switch (collectionFormat) {
            case "ssv": {
                return StringUtil.join(stringArray, " ");
            }
            case "tsv": {
                return StringUtil.join(stringArray, "\t");
            }
            case "pipes": {
                return StringUtil.join(stringArray, "|");
            }
        }
        return StringUtil.join(stringArray, ",");
    }

    public static String encode(Object parameter) {
        if (parameter == null) {
            return null;
        }
        try {
            return URLEncoder.encode(parameter.toString(), "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Should never happen, UTF-8 is always supported", e);
        }
    }
}

