/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl.bdm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.client.services.impl.bdm.BdmResponseConverter;
import org.bonitasoft.web.feign.GenericApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdmResponseProxyInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BdmResponseProxyInvocationHandler.class);
    private final Map<String, String> links = new HashMap<String, String>();
    private final Map<String, Object> jsonData;
    private final BdmResponseConverter bdmResponseConverter;

    public BdmResponseProxyInvocationHandler(BdmResponseConverter bdmResponseConverter, Map<String, Object> jsonData) {
        this.bdmResponseConverter = bdmResponseConverter;
        this.jsonData = jsonData;
        this.processLinks(this.jsonData);
    }

    private void processLinks(Map<String, Object> jsonData) {
        List jsonLinks = jsonData.getOrDefault("links", new ArrayList());
        jsonLinks.forEach(link -> {
            String rel = this.createLinkKey((Map<String, String>)link);
            String href = (String)link.get("href");
            this.links.put(rel, href);
        });
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value;
        if (method.getDeclaringClass() != Object.class && this.isLazyGet(method)) {
            log.debug("Fetch lazy data for {}", (Object)method.getName());
            String href = this.links.get(this.getLinkKey(method));
            href = this.removeFirstSlash(href);
            GenericApi call = this.bdmResponseConverter.getApiProvider().get(GenericApi.class);
            if (Collection.class.isAssignableFrom(method.getReturnType())) {
                List<Map<String, Object>> body = call.getList(href);
                Class returnType = (Class)this.getGenericType(method);
                return this.bdmResponseConverter.convertToList(body, returnType);
            }
            Map<String, Object> body = call.get(href);
            return this.bdmResponseConverter.convert(body, method.getReturnType());
        }
        String key = this.getFieldKey(method);
        String stringedKey = key + "_string";
        if (this.jsonData.containsKey(stringedKey)) {
            log.debug("Get data from json response field {}", (Object)stringedKey);
            value = this.jsonData.get(stringedKey);
        } else {
            log.debug("Get data from json response field {}", (Object)key);
            value = this.jsonData.get(key);
        }
        return this.bdmResponseConverter.getObjectMapper().convertValue(value, method.getReturnType());
    }

    private String removeFirstSlash(String url) {
        if (url.startsWith("/")) {
            return url.substring(1);
        }
        return url;
    }

    Type getGenericType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)returnType;
            Type[] argTypes = paramType.getActualTypeArguments();
            if (argTypes.length > 0) {
                return argTypes[0];
            }
            return Object.class;
        }
        return Object.class;
    }

    private String createLinkKey(Map<String, String> link) {
        return link.get("rel").toLowerCase();
    }

    protected String getLinkKey(Method method) {
        return method.getName().replace("get", "").toLowerCase();
    }

    protected String getFieldKey(Method method) {
        return this.lowercaseFirst(method.getName().replace("get", ""));
    }

    protected String lowercaseFirst(String text) {
        char[] c = text.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    private boolean isLazyGet(Method method) {
        return this.links.containsKey(this.getLinkKey(method));
    }
}

