/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Bonita license")
@JsonPropertyOrder(value={"owner", "edition", "nb_cpu_cores", "expirationDate"})
@JsonTypeName(value="License")
public class License
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private String owner;
    public static final String JSON_PROPERTY_EDITION = "edition";
    private String edition;
    public static final String JSON_PROPERTY_NB_CPU_CORES = "nb_cpu_cores";
    private String nbCpuCores;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    private Long expirationDate;

    public License owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Owner of the license")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public License edition(String edition) {
        this.edition = edition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of the Bonita edition enabled by the license (Community,...)")
    @JsonProperty(value="edition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEdition() {
        return this.edition;
    }

    @JsonProperty(value="edition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEdition(String edition) {
        this.edition = edition;
    }

    public License nbCpuCores(String nbCpuCores) {
        this.nbCpuCores = nbCpuCores;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="number of CPUs")
    @JsonProperty(value="nb_cpu_cores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNbCpuCores() {
        return this.nbCpuCores;
    }

    @JsonProperty(value="nb_cpu_cores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNbCpuCores(String nbCpuCores) {
        this.nbCpuCores = nbCpuCores;
    }

    public License expirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License expiration date with format: `yyyy-MM-dd HH:mm:ss.SSS`")
    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return Objects.equals(this.owner, license.owner) && Objects.equals(this.edition, license.edition) && Objects.equals(this.nbCpuCores, license.nbCpuCores) && Objects.equals(this.expirationDate, license.expirationDate);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.edition, this.nbCpuCores, this.expirationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class License {\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    edition: ").append(this.toIndentedString(this.edition)).append("\n");
        sb.append("    nbCpuCores: ").append(this.toIndentedString(this.nbCpuCores)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

