/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "token", "applicationId", "pageId"})
@JsonTypeName(value="ApplicationPage")
public class ApplicationPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
    private String applicationId;
    public static final String JSON_PROPERTY_PAGE_ID = "pageId";
    private String pageId;

    public ApplicationPage id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the application page item")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ApplicationPage token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="token use to access the page using a URL : ../appName/pageToken/")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public ApplicationPage applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the application related to this page")
    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ApplicationPage pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the custom page to display")
    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageId() {
        return this.pageId;
    }

    @JsonProperty(value="pageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPage applicationPage = (ApplicationPage)o;
        return Objects.equals(this.id, applicationPage.id) && Objects.equals(this.token, applicationPage.token) && Objects.equals(this.applicationId, applicationPage.applicationId) && Objects.equals(this.pageId, applicationPage.pageId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.token, this.applicationId, this.pageId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationPage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

