/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An archived case variable")
@JsonPropertyOrder(value={"name", "description", "type", "case_id", "value", "archivedDate", "sourcedObjectId"})
@JsonTypeName(value="ArchivedProcessInstanceVariable")
public class ArchivedProcessInstanceVariable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_CASE_ID = "case_id";
    private String caseId;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;
    public static final String JSON_PROPERTY_ARCHIVED_DATE = "archivedDate";
    private String archivedDate;
    public static final String JSON_PROPERTY_SOURCED_OBJECT_ID = "sourcedObjectId";
    private String sourcedObjectId;

    public ArchivedProcessInstanceVariable name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the variable")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ArchivedProcessInstanceVariable description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Detailed description of the case variable, as set in the definition at design-time")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ArchivedProcessInstanceVariable type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fully qualified class name of the variable type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public ArchivedProcessInstanceVariable caseId(String caseId) {
        this.caseId = caseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the case this variable belongs to")
    @JsonProperty(value="case_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCaseId() {
        return this.caseId;
    }

    @JsonProperty(value="case_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public ArchivedProcessInstanceVariable value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the value of this variable. The format of the value depends on the type of the variable")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public ArchivedProcessInstanceVariable archivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when this variable was archived. The date format is yyyy-MM-dd HH:mm:ss.SSS")
    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchivedDate() {
        return this.archivedDate;
    }

    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
    }

    public ArchivedProcessInstanceVariable sourcedObjectId(String sourcedObjectId) {
        this.sourcedObjectId = sourcedObjectId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the variable before it was archived")
    @JsonProperty(value="sourcedObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourcedObjectId() {
        return this.sourcedObjectId;
    }

    @JsonProperty(value="sourcedObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcedObjectId(String sourcedObjectId) {
        this.sourcedObjectId = sourcedObjectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedProcessInstanceVariable archivedProcessInstanceVariable = (ArchivedProcessInstanceVariable)o;
        return Objects.equals(this.name, archivedProcessInstanceVariable.name) && Objects.equals(this.description, archivedProcessInstanceVariable.description) && Objects.equals(this.type, archivedProcessInstanceVariable.type) && Objects.equals(this.caseId, archivedProcessInstanceVariable.caseId) && Objects.equals(this.value, archivedProcessInstanceVariable.value) && Objects.equals(this.archivedDate, archivedProcessInstanceVariable.archivedDate) && Objects.equals(this.sourcedObjectId, archivedProcessInstanceVariable.sourcedObjectId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.caseId, this.value, this.archivedDate, this.sourcedObjectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchivedProcessInstanceVariable {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    caseId: ").append(this.toIndentedString(this.caseId)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("    sourcedObjectId: ").append(this.toIndentedString(this.sourcedObjectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

