/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"username", "password", "tenant", "redirect", "redirectURL"})
public class LoginRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_TENANT = "tenant";
    private String tenant;
    public static final String JSON_PROPERTY_REDIRECT = "redirect";
    private String redirect = "false";
    public static final String JSON_PROPERTY_REDIRECT_U_R_L = "redirectURL";
    private JsonNullable<String> redirectURL = JsonNullable.of((Object)"");

    public LoginRequest username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="the username")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public LoginRequest password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(required=true, value="the password")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public LoginRequest tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the user tenant")
    @JsonProperty(value="tenant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public LoginRequest redirect(String redirect) {
        this.redirect = redirect;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\"true\" or \"false\". \"false\" indicates that the service should not redirect to Bonita Portal (after a successful login) or to the login page (after a login failure).")
    @JsonProperty(value="redirect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public LoginRequest redirectURL(String redirectURL) {
        this.redirectURL = JsonNullable.of((Object)redirectURL);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the URL of the page to be displayed after login")
    @JsonIgnore
    public String getRedirectURL() {
        return (String)this.redirectURL.orElse(null);
    }

    @JsonProperty(value="redirectURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRedirectURL_JsonNullable() {
        return this.redirectURL;
    }

    @JsonProperty(value="redirectURL")
    public void setRedirectURL_JsonNullable(JsonNullable<String> redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = JsonNullable.of((Object)redirectURL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginRequest loginRequest = (LoginRequest)o;
        return Objects.equals(this.username, loginRequest.username) && Objects.equals(this.password, loginRequest.password) && Objects.equals(this.tenant, loginRequest.tenant) && Objects.equals(this.redirect, loginRequest.redirect) && Objects.equals(this.redirectURL, loginRequest.redirectURL);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.tenant, this.redirect, this.redirectURL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginRequest {\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    redirect: ").append(this.toIndentedString(this.redirect)).append("\n");
        sb.append("    redirectURL: ").append(this.toIndentedString(this.redirectURL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

