/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.ApiResponse;
import org.bonitasoft.web.client.model.Membership;
import org.bonitasoft.web.client.model.MembershipCreateRequest;

public interface MembershipApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/identity/membership")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Membership createMembership(MembershipCreateRequest var1);

    @RequestLine(value="POST /API/identity/membership")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Membership> createMembershipWithHttpInfo(MembershipCreateRequest var1);

    @RequestLine(value="DELETE /API/identity/membership/{userId}/{groupId}/{roleId}")
    @Headers(value={"Accept: application/json"})
    public void deleteMembershipById(@Param(value="userId") String var1, @Param(value="groupId") String var2, @Param(value="roleId") String var3);

    @RequestLine(value="DELETE /API/identity/membership/{userId}/{groupId}/{roleId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMembershipByIdWithHttpInfo(@Param(value="userId") String var1, @Param(value="groupId") String var2, @Param(value="roleId") String var3);

    @RequestLine(value="GET /API/identity/membership?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<Membership> searchMemberships(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4, @Param(value="s") String var5);

    @RequestLine(value="GET /API/identity/membership?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Membership>> searchMembershipsWithHttpInfo(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4, @Param(value="s") String var5);

    @RequestLine(value="GET /API/identity/membership?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<Membership> searchMemberships(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /API/identity/membership?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Membership>> searchMembershipsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    public static class SearchMembershipsQueryParams
    extends HashMap<String, Object> {
        public SearchMembershipsQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchMembershipsQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchMembershipsQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchMembershipsQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }

        public SearchMembershipsQueryParams s(String value) {
            this.put("s", EncodingUtils.encode(value));
            return this;
        }
    }
}

