/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.feign.decoder;

import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.exception.NotFoundException;
import org.bonitasoft.web.client.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonitaErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(BonitaErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        int responseStatus = response.status();
        String message = String.format("status: %s %s %s", responseStatus, response.reason(), System.lineSeparator());
        String details = this.getMessageDetails(response);
        String errorMessage = message + details;
        if (responseStatus == 401) {
            return new UnauthorizedException(errorMessage);
        }
        if (responseStatus == 404) {
            return new NotFoundException(errorMessage);
        }
        if (responseStatus >= 400 && responseStatus <= 599) {
            return new ClientException(errorMessage);
        }
        return FeignException.errorStatus((String)methodKey, (Response)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessageDetails(Response response) {
        try {
            String string;
            block11: {
                Response.Body responseBody = response.body();
                try {
                    string = Optional.ofNullable(responseBody).map(body -> {
                        StringBuilder messageDetails = new StringBuilder(" :" + System.lineSeparator());
                        try (InputStream inputStream = body.asInputStream();){
                            String responseText = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining(System.lineSeparator()));
                            messageDetails.append(responseText);
                        }
                        catch (Exception e) {
                            log.error("Failed to read error response text.", (Throwable)e);
                        }
                        return messageDetails.toString();
                    }).orElse("");
                    if (responseBody == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (responseBody != null) {
                            try {
                                responseBody.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error("Failed to read error response body", (Throwable)e);
                        String string2 = "";
                        return string2;
                    }
                }
                responseBody.close();
            }
            return string;
        }
        finally {
            response.close();
        }
    }
}

