/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessInstance (Case) is an instance of a process. When you start a process, it creates a process instances.")
@JsonPropertyOrder(value={"id", "end_date", "failedFlowNodes", "startedBySubstitute", "start", "activeFlowNodes", "state", "rootCaseId", "started_by", "processDefinitionId", "last_update_date", "searchIndex1Label", "searchIndex2Label", "searchIndex3Label", "searchIndex4Label", "searchIndex5Label", "searchIndex1Value", "searchIndex2Value", "searchIndex3Value", "searchIndex4Value", "searchIndex5Value"})
@JsonTypeName(value="ProcessInstance")
public class ProcessInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_END_DATE = "end_date";
    private String endDate;
    public static final String JSON_PROPERTY_FAILED_FLOW_NODES = "failedFlowNodes";
    private String failedFlowNodes;
    public static final String JSON_PROPERTY_STARTED_BY_SUBSTITUTE = "startedBySubstitute";
    private String startedBySubstitute;
    public static final String JSON_PROPERTY_START = "start";
    private String start;
    public static final String JSON_PROPERTY_ACTIVE_FLOW_NODES = "activeFlowNodes";
    private String activeFlowNodes;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_ROOT_CASE_ID = "rootCaseId";
    private String rootCaseId;
    public static final String JSON_PROPERTY_STARTED_BY = "started_by";
    private String startedBy;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private String processDefinitionId;
    public static final String JSON_PROPERTY_LAST_UPDATE_DATE = "last_update_date";
    private String lastUpdateDate;
    public static final String JSON_PROPERTY_SEARCH_INDEX1_LABEL = "searchIndex1Label";
    private String searchIndex1Label;
    public static final String JSON_PROPERTY_SEARCH_INDEX2_LABEL = "searchIndex2Label";
    private String searchIndex2Label;
    public static final String JSON_PROPERTY_SEARCH_INDEX3_LABEL = "searchIndex3Label";
    private String searchIndex3Label;
    public static final String JSON_PROPERTY_SEARCH_INDEX4_LABEL = "searchIndex4Label";
    private String searchIndex4Label;
    public static final String JSON_PROPERTY_SEARCH_INDEX5_LABEL = "searchIndex5Label";
    private String searchIndex5Label;
    public static final String JSON_PROPERTY_SEARCH_INDEX1_VALUE = "searchIndex1Value";
    private String searchIndex1Value;
    public static final String JSON_PROPERTY_SEARCH_INDEX2_VALUE = "searchIndex2Value";
    private String searchIndex2Value;
    public static final String JSON_PROPERTY_SEARCH_INDEX3_VALUE = "searchIndex3Value";
    private String searchIndex3Value;
    public static final String JSON_PROPERTY_SEARCH_INDEX4_VALUE = "searchIndex4Value";
    private String searchIndex4Value;
    public static final String JSON_PROPERTY_SEARCH_INDEX5_VALUE = "searchIndex5Value";
    private String searchIndex5Value;

    public ProcessInstance id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the identifier of the ProcessInstance (Case)")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ProcessInstance endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date set when the process instance is closed")
    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ProcessInstance failedFlowNodes(String failedFlowNodes) {
        this.failedFlowNodes = failedFlowNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="count of failed flow nodes if parameter n=failedFlowNodes is given")
    @JsonProperty(value="failedFlowNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailedFlowNodes() {
        return this.failedFlowNodes;
    }

    @JsonProperty(value="failedFlowNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedFlowNodes(String failedFlowNodes) {
        this.failedFlowNodes = failedFlowNodes;
    }

    public ProcessInstance startedBySubstitute(String startedBySubstitute) {
        this.startedBySubstitute = startedBySubstitute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the identifier of the substitute user (as Process manager or Administrator) who started the process. It can be also the substitute user if d=startedBySubstitute is given.")
    @JsonProperty(value="startedBySubstitute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartedBySubstitute() {
        return this.startedBySubstitute;
    }

    @JsonProperty(value="startedBySubstitute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartedBySubstitute(String startedBySubstitute) {
        this.startedBySubstitute = startedBySubstitute;
    }

    public ProcessInstance start(String start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the starting date of the case")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStart(String start) {
        this.start = start;
    }

    public ProcessInstance activeFlowNodes(String activeFlowNodes) {
        this.activeFlowNodes = activeFlowNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="count of active flow nodes if parameter n=activeFlowNodes is given")
    @JsonProperty(value="activeFlowNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActiveFlowNodes() {
        return this.activeFlowNodes;
    }

    @JsonProperty(value="activeFlowNodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActiveFlowNodes(String activeFlowNodes) {
        this.activeFlowNodes = activeFlowNodes;
    }

    public ProcessInstance state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="state: an enum that represent the state of the process instances, it can be INITIALIZING, STARTED, SUSPENDED, CANCELLED, ABORTED, COMPLETING, COMPLETED, ERROR, ABORTING")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public ProcessInstance rootCaseId(String rootCaseId) {
        this.rootCaseId = rootCaseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the identifier of the container of the case")
    @JsonProperty(value="rootCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRootCaseId() {
        return this.rootCaseId;
    }

    @JsonProperty(value="rootCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRootCaseId(String rootCaseId) {
        this.rootCaseId = rootCaseId;
    }

    public ProcessInstance startedBy(String startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the identifier of the user who started the case")
    @JsonProperty(value="started_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartedBy() {
        return this.startedBy;
    }

    @JsonProperty(value="started_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public ProcessInstance processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the identifier of the process related of the case")
    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ProcessInstance lastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date of the last update done on the case")
    @JsonProperty(value="last_update_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    @JsonProperty(value="last_update_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public ProcessInstance searchIndex1Label(String searchIndex1Label) {
        this.searchIndex1Label = searchIndex1Label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 1st search index label (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex1Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex1Label() {
        return this.searchIndex1Label;
    }

    @JsonProperty(value="searchIndex1Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex1Label(String searchIndex1Label) {
        this.searchIndex1Label = searchIndex1Label;
    }

    public ProcessInstance searchIndex2Label(String searchIndex2Label) {
        this.searchIndex2Label = searchIndex2Label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 2nd search index label (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex2Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex2Label() {
        return this.searchIndex2Label;
    }

    @JsonProperty(value="searchIndex2Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex2Label(String searchIndex2Label) {
        this.searchIndex2Label = searchIndex2Label;
    }

    public ProcessInstance searchIndex3Label(String searchIndex3Label) {
        this.searchIndex3Label = searchIndex3Label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 3rd search index label (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex3Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex3Label() {
        return this.searchIndex3Label;
    }

    @JsonProperty(value="searchIndex3Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex3Label(String searchIndex3Label) {
        this.searchIndex3Label = searchIndex3Label;
    }

    public ProcessInstance searchIndex4Label(String searchIndex4Label) {
        this.searchIndex4Label = searchIndex4Label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 4th search index label (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex4Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex4Label() {
        return this.searchIndex4Label;
    }

    @JsonProperty(value="searchIndex4Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex4Label(String searchIndex4Label) {
        this.searchIndex4Label = searchIndex4Label;
    }

    public ProcessInstance searchIndex5Label(String searchIndex5Label) {
        this.searchIndex5Label = searchIndex5Label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 5th search index label (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex5Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex5Label() {
        return this.searchIndex5Label;
    }

    @JsonProperty(value="searchIndex5Label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex5Label(String searchIndex5Label) {
        this.searchIndex5Label = searchIndex5Label;
    }

    public ProcessInstance searchIndex1Value(String searchIndex1Value) {
        this.searchIndex1Value = searchIndex1Value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 1st search index value (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex1Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex1Value() {
        return this.searchIndex1Value;
    }

    @JsonProperty(value="searchIndex1Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex1Value(String searchIndex1Value) {
        this.searchIndex1Value = searchIndex1Value;
    }

    public ProcessInstance searchIndex2Value(String searchIndex2Value) {
        this.searchIndex2Value = searchIndex2Value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 2nd search index value (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex2Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex2Value() {
        return this.searchIndex2Value;
    }

    @JsonProperty(value="searchIndex2Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex2Value(String searchIndex2Value) {
        this.searchIndex2Value = searchIndex2Value;
    }

    public ProcessInstance searchIndex3Value(String searchIndex3Value) {
        this.searchIndex3Value = searchIndex3Value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 3rd search index value (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex3Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex3Value() {
        return this.searchIndex3Value;
    }

    @JsonProperty(value="searchIndex3Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex3Value(String searchIndex3Value) {
        this.searchIndex3Value = searchIndex3Value;
    }

    public ProcessInstance searchIndex4Value(String searchIndex4Value) {
        this.searchIndex4Value = searchIndex4Value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 4th search index value (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex4Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex4Value() {
        return this.searchIndex4Value;
    }

    @JsonProperty(value="searchIndex4Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex4Value(String searchIndex4Value) {
        this.searchIndex4Value = searchIndex4Value;
    }

    public ProcessInstance searchIndex5Value(String searchIndex5Value) {
        this.searchIndex5Value = searchIndex5Value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the 5th search index value (from 6.5, in Subscription editions only)")
    @JsonProperty(value="searchIndex5Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchIndex5Value() {
        return this.searchIndex5Value;
    }

    @JsonProperty(value="searchIndex5Value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchIndex5Value(String searchIndex5Value) {
        this.searchIndex5Value = searchIndex5Value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstance processInstance = (ProcessInstance)o;
        return Objects.equals(this.id, processInstance.id) && Objects.equals(this.endDate, processInstance.endDate) && Objects.equals(this.failedFlowNodes, processInstance.failedFlowNodes) && Objects.equals(this.startedBySubstitute, processInstance.startedBySubstitute) && Objects.equals(this.start, processInstance.start) && Objects.equals(this.activeFlowNodes, processInstance.activeFlowNodes) && Objects.equals(this.state, processInstance.state) && Objects.equals(this.rootCaseId, processInstance.rootCaseId) && Objects.equals(this.startedBy, processInstance.startedBy) && Objects.equals(this.processDefinitionId, processInstance.processDefinitionId) && Objects.equals(this.lastUpdateDate, processInstance.lastUpdateDate) && Objects.equals(this.searchIndex1Label, processInstance.searchIndex1Label) && Objects.equals(this.searchIndex2Label, processInstance.searchIndex2Label) && Objects.equals(this.searchIndex3Label, processInstance.searchIndex3Label) && Objects.equals(this.searchIndex4Label, processInstance.searchIndex4Label) && Objects.equals(this.searchIndex5Label, processInstance.searchIndex5Label) && Objects.equals(this.searchIndex1Value, processInstance.searchIndex1Value) && Objects.equals(this.searchIndex2Value, processInstance.searchIndex2Value) && Objects.equals(this.searchIndex3Value, processInstance.searchIndex3Value) && Objects.equals(this.searchIndex4Value, processInstance.searchIndex4Value) && Objects.equals(this.searchIndex5Value, processInstance.searchIndex5Value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.endDate, this.failedFlowNodes, this.startedBySubstitute, this.start, this.activeFlowNodes, this.state, this.rootCaseId, this.startedBy, this.processDefinitionId, this.lastUpdateDate, this.searchIndex1Label, this.searchIndex2Label, this.searchIndex3Label, this.searchIndex4Label, this.searchIndex5Label, this.searchIndex1Value, this.searchIndex2Value, this.searchIndex3Value, this.searchIndex4Value, this.searchIndex5Value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstance {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    failedFlowNodes: ").append(this.toIndentedString(this.failedFlowNodes)).append("\n");
        sb.append("    startedBySubstitute: ").append(this.toIndentedString(this.startedBySubstitute)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    activeFlowNodes: ").append(this.toIndentedString(this.activeFlowNodes)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    rootCaseId: ").append(this.toIndentedString(this.rootCaseId)).append("\n");
        sb.append("    startedBy: ").append(this.toIndentedString(this.startedBy)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    searchIndex1Label: ").append(this.toIndentedString(this.searchIndex1Label)).append("\n");
        sb.append("    searchIndex2Label: ").append(this.toIndentedString(this.searchIndex2Label)).append("\n");
        sb.append("    searchIndex3Label: ").append(this.toIndentedString(this.searchIndex3Label)).append("\n");
        sb.append("    searchIndex4Label: ").append(this.toIndentedString(this.searchIndex4Label)).append("\n");
        sb.append("    searchIndex5Label: ").append(this.toIndentedString(this.searchIndex5Label)).append("\n");
        sb.append("    searchIndex1Value: ").append(this.toIndentedString(this.searchIndex1Value)).append("\n");
        sb.append("    searchIndex2Value: ").append(this.toIndentedString(this.searchIndex2Value)).append("\n");
        sb.append("    searchIndex3Value: ").append(this.toIndentedString(this.searchIndex3Value)).append("\n");
        sb.append("    searchIndex4Value: ").append(this.toIndentedString(this.searchIndex4Value)).append("\n");
        sb.append("    searchIndex5Value: ").append(this.toIndentedString(this.searchIndex5Value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

