/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.bonitasoft.web.client.api.ApplicationApi;
import org.bonitasoft.web.client.api.PageApi;
import org.bonitasoft.web.client.exception.ClientException;
import org.bonitasoft.web.client.exception.LicenseException;
import org.bonitasoft.web.client.exception.NotFoundException;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.Application;
import org.bonitasoft.web.client.model.Page;
import org.bonitasoft.web.client.model.PageCreateRequest;
import org.bonitasoft.web.client.model.PageUpdateRequest;
import org.bonitasoft.web.client.services.ApplicationService;
import org.bonitasoft.web.client.services.impl.base.AbstractService;
import org.bonitasoft.web.client.services.impl.base.ClientContext;
import org.bonitasoft.web.client.services.impl.xml.XmlDocumentParser;
import org.bonitasoft.web.client.services.policies.ApplicationImportPolicy;
import org.bonitasoft.web.client.services.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultApplicationService
extends AbstractService
implements ApplicationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationService.class);

    public DefaultApplicationService(ClientContext clientContext, ApiProvider apiProvider, ObjectMapper objectMapper) {
        super(apiProvider, objectMapper, clientContext);
    }

    @Override
    public void importApplications(File applicationFile, ApplicationImportPolicy policy) {
        log.info("Deploying applications in '{}' using policy {}", (Object)applicationFile.getName(), (Object)policy.name());
        if (policy.equals((Object)ApplicationImportPolicy.REPLACE_DUPLICATES)) {
            log.debug("Policy REPLACE_DUPLICATES: deleting existing applications...");
            this.readApplicationTokensFromFile(applicationFile).forEach(this::silentDeleteApplication);
            log.debug("Existing applicationFile deleted successfully.");
            policy = ApplicationImportPolicy.FAIL_ON_DUPLICATES;
        }
        log.debug("Uploading applicationFile file...");
        ApplicationApi applicationApi = this.apiProvider.get(ApplicationApi.class);
        String uploadedFileName = applicationApi.uploadApplication(applicationFile);
        log.debug("Application file uploaded successfully.");
        applicationApi.importApplication(uploadedFileName, policy.name());
        log.info("Applications in '{}' deployed successfully.", (Object)applicationFile.getName());
    }

    void silentDeleteApplication(String applicationToken) {
        try {
            this.deleteApplication(applicationToken);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    List<String> readApplicationTokensFromFile(File application) {
        log.debug("Extract application token from file: {}", (Object)application.getName());
        ArrayList<String> tokens = new ArrayList<String>();
        XmlDocumentParser documentParser = new XmlDocumentParser();
        Document doc = documentParser.parse(application);
        NodeList nodeList = documentParser.queryNodeList(doc, "/applications/application/@token");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            tokens.add(item.getNodeValue());
        }
        return tokens;
    }

    @Override
    public Application getApplication(String applicationToken) {
        log.info("Get application '{}'", (Object)applicationToken);
        return (Application)this.apiProvider.get(ApplicationApi.class).searchApplications(new ApplicationApi.SearchApplicationsQueryParams().p(0).c(1).f(Collections.singletonList("token=" + applicationToken))).stream().findFirst().orElseThrow(() -> new NotFoundException(String.format("Application not found: %s", applicationToken)));
    }

    @Override
    public List<Application> searchApplications(int page, int count) {
        return this.searchApplications(new ApplicationApi.SearchApplicationsQueryParams().p(page).c(count));
    }

    @Override
    public List<Application> searchApplications(ApplicationApi.SearchApplicationsQueryParams params) {
        log.info("Search applications with params {}", (Object)params);
        return this.apiProvider.get(ApplicationApi.class).searchApplications(params);
    }

    @Override
    public void deleteApplication(String applicationToken) {
        log.info("Deleting application: {}", (Object)applicationToken);
        Application application = this.getApplication(applicationToken);
        this.apiProvider.get(ApplicationApi.class).deleteApplicationById(application.getId());
        log.info("Application {} deleted", (Object)applicationToken);
    }

    @Override
    public void importBonitaConfiguration(File configurationFile) {
        if (this.isCommunity()) {
            String message = "Bonita Configuration deployment skipped: your current Bonita license is 'Community' and this feature is only supported in 'Subscription' editions.";
            throw new LicenseException(message);
        }
        log.info("Deploying configuration '{}'...", (Object)configurationFile.getName());
        String uploadedFileName = this.apiProvider.get(ApplicationApi.class).uploadApplicationConfiguration(configurationFile);
        log.debug("Bconf upload response: {}", (Object)uploadedFileName);
        log.info("Configuration deployed successfully.");
    }

    @Override
    public Page importPage(File pageZip) {
        Page page;
        log.info("Deploying page '{}'...", (Object)pageZip.getName());
        PageApi pageApi = this.apiProvider.get(PageApi.class);
        log.debug("Uploading page file...");
        String uploadedFileName = pageApi.uploadPage(pageZip);
        log.debug("Page file uploaded successfully.");
        try {
            page = this.getPage(pageZip);
            log.debug("Updating existing page...");
            pageApi.updatePageById(page.getId(), new PageUpdateRequest().pageZip(uploadedFileName));
        }
        catch (NotFoundException e) {
            log.debug("Creating new page...");
            page = pageApi.createPage(new PageCreateRequest().pageZip(uploadedFileName));
        }
        log.info("Page deployed successfully.");
        return page;
    }

    private Page getPage(File pageZip) {
        try {
            log.debug("Extract page name from page.properties in file: {}", (Object)pageZip.getName());
            byte[] pageProperties = FileUtils.getFileFromZip(pageZip, "page.properties");
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(pageProperties));
            String name = properties.getProperty("name");
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid page %s, page.properties do not contains a name attribute", pageZip.getPath()));
            }
            return this.getPage(name);
        }
        catch (IOException e) {
            String message = "Failed to read page token from page zip file: " + pageZip.getName();
            log.error(message, (Throwable)e);
            throw new ClientException(message);
        }
    }

    @Override
    public List<Page> searchPages(int page, int count) {
        return this.searchPages(new PageApi.SearchPagesQueryParams().p(page).c(count));
    }

    @Override
    public List<Page> searchPages(PageApi.SearchPagesQueryParams params) {
        log.info("Search pages with request params {}", (Object)params);
        return this.apiProvider.get(PageApi.class).searchPages(params);
    }

    @Override
    public Page getPage(String token) {
        log.info("Get page '{}'", (Object)token);
        List<Page> pages = this.apiProvider.get(PageApi.class).searchPages(new PageApi.SearchPagesQueryParams().p(0).c(1).f(Collections.singletonList("urlToken=" + token)));
        if (pages.isEmpty()) {
            log.debug("Can't find any existing page with the token '{}'.", (Object)token);
            throw new NotFoundException("No page found for token: " + token);
        }
        log.debug("Page '{}' found successfully.", (Object)token);
        return pages.get(0);
    }

    @Override
    public void deletePage(String token) {
        log.info("Deleting page '{}'...", (Object)token);
        Page page = this.getPage(token);
        this.apiProvider.get(PageApi.class).deletePageById(page.getId());
        log.info("Page '{}' deleted", (Object)token);
    }
}

