/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bonitasoft.web.client.model.ActivityPriority;
import org.bonitasoft.web.client.model.ActivityState;
import org.bonitasoft.web.client.model.ActivityType;

@ApiModel(description="Use this resource to retrieve finished activities (human or service tasks), call activities, and subprocesses.")
@JsonPropertyOrder(value={"id", "type", "name", "displayName", "description", "displayDescription", "state", "reached_state_date", "last_update_date", "dueDate", "priority", "processId", "parentCaseId", "rootCaseId", "rootContainerId", "executedBy", "executedBySubstitute", "actorId", "assigned_id", "assigned_date", "sourceObjectId", "archivedDate"})
public class ArchivedActivity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ActivityType type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_DESCRIPTION = "displayDescription";
    private String displayDescription;
    public static final String JSON_PROPERTY_STATE = "state";
    private ActivityState state;
    public static final String JSON_PROPERTY_REACHED_STATE_DATE = "reached_state_date";
    private String reachedStateDate;
    public static final String JSON_PROPERTY_LAST_UPDATE_DATE = "last_update_date";
    private String lastUpdateDate;
    public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
    private String dueDate;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private ActivityPriority priority;
    public static final String JSON_PROPERTY_PROCESS_ID = "processId";
    private String processId;
    public static final String JSON_PROPERTY_PARENT_CASE_ID = "parentCaseId";
    private String parentCaseId;
    public static final String JSON_PROPERTY_ROOT_CASE_ID = "rootCaseId";
    private String rootCaseId;
    public static final String JSON_PROPERTY_ROOT_CONTAINER_ID = "rootContainerId";
    private String rootContainerId;
    public static final String JSON_PROPERTY_EXECUTED_BY = "executedBy";
    private String executedBy;
    public static final String JSON_PROPERTY_EXECUTED_BY_SUBSTITUTE = "executedBySubstitute";
    private String executedBySubstitute;
    public static final String JSON_PROPERTY_ACTOR_ID = "actorId";
    private String actorId;
    public static final String JSON_PROPERTY_ASSIGNED_ID = "assigned_id";
    private String assignedId;
    public static final String JSON_PROPERTY_ASSIGNED_DATE = "assigned_date";
    private String assignedDate;
    public static final String JSON_PROPERTY_SOURCE_OBJECT_ID = "sourceObjectId";
    private String sourceObjectId;
    public static final String JSON_PROPERTY_ARCHIVED_DATE = "archivedDate";
    private String archivedDate;

    public ArchivedActivity id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the archived activity id")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ArchivedActivity type(ActivityType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActivityType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(ActivityType type) {
        this.type = type;
    }

    public ArchivedActivity name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the archived activity technical name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ArchivedActivity displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the human readable archived activity name")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ArchivedActivity description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the archived activity description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ArchivedActivity displayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the human readable archived activity description")
    @JsonProperty(value="displayDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    @JsonProperty(value="displayDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ArchivedActivity state(ActivityState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActivityState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(ActivityState state) {
        this.state = state;
    }

    public ArchivedActivity reachedStateDate(String reachedStateDate) {
        this.reachedStateDate = reachedStateDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date ('yyyy-MM-dd HH:mm:ss.SSS') when this archived activity reached the current state, for example '2014-10-17 16:05:42.626'")
    @JsonProperty(value="reached_state_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReachedStateDate() {
        return this.reachedStateDate;
    }

    @JsonProperty(value="reached_state_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReachedStateDate(String reachedStateDate) {
        this.reachedStateDate = reachedStateDate;
    }

    public ArchivedActivity lastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date ('yyyy-MM-dd HH:mm:ss.SSS') when this archived activity was last updated, for example '2014-10-17 16:05:42.626)")
    @JsonProperty(value="last_update_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    @JsonProperty(value="last_update_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public ArchivedActivity dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date ('yyyy-MM-dd HH:mm:ss.SSS') when this archived activity is due, for example '2014-10-17 16:05:42.626'")
    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public ArchivedActivity priority(ActivityPriority priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActivityPriority getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(ActivityPriority priority) {
        this.priority = priority;
    }

    public ArchivedActivity processId(String processId) {
        this.processId = processId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the process definition id of the process instance which define this archived activity")
    @JsonProperty(value="processId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessId() {
        return this.processId;
    }

    @JsonProperty(value="processId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public ArchivedActivity parentCaseId(String parentCaseId) {
        this.parentCaseId = parentCaseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the immediate containing process instance id (a.k.a case id)")
    @JsonProperty(value="parentCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentCaseId() {
        return this.parentCaseId;
    }

    @JsonProperty(value="parentCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentCaseId(String parentCaseId) {
        this.parentCaseId = parentCaseId;
    }

    public ArchivedActivity rootCaseId(String rootCaseId) {
        this.rootCaseId = rootCaseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the top/root process instance id (a.k.a case id). In case of an \"event sub process\", `parentCaseId` will the id of the process instance called while `rootCaseId` will be the one from the caller case")
    @JsonProperty(value="rootCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRootCaseId() {
        return this.rootCaseId;
    }

    @JsonProperty(value="rootCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRootCaseId(String rootCaseId) {
        this.rootCaseId = rootCaseId;
    }

    public ArchivedActivity rootContainerId(String rootContainerId) {
        this.rootContainerId = rootContainerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="same as `rootCaseId`")
    @JsonProperty(value="rootContainerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRootContainerId() {
        return this.rootContainerId;
    }

    @JsonProperty(value="rootContainerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRootContainerId(String rootContainerId) {
        this.rootContainerId = rootContainerId;
    }

    public ArchivedActivity executedBy(String executedBy) {
        this.executedBy = executedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the id of the user who performed this archived activity. The archived activity has to be a human task otherwise its value will be 0")
    @JsonProperty(value="executedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExecutedBy() {
        return this.executedBy;
    }

    @JsonProperty(value="executedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutedBy(String executedBy) {
        this.executedBy = executedBy;
    }

    public ArchivedActivity executedBySubstitute(String executedBySubstitute) {
        this.executedBySubstitute = executedBySubstitute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the id of the user who did actually performed the archived activity when it has been done in the name of someone else. Value is 0 otherwise")
    @JsonProperty(value="executedBySubstitute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExecutedBySubstitute() {
        return this.executedBySubstitute;
    }

    @JsonProperty(value="executedBySubstitute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutedBySubstitute(String executedBySubstitute) {
        this.executedBySubstitute = executedBySubstitute;
    }

    public ArchivedActivity actorId(String actorId) {
        this.actorId = actorId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the id of the actor that can execute this archived activity, null otherwise")
    @JsonProperty(value="actorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActorId() {
        return this.actorId;
    }

    @JsonProperty(value="actorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public ArchivedActivity assignedId(String assignedId) {
        this.assignedId = assignedId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the user id that this archived activity is assigned to, or 0 if it is unassigned")
    @JsonProperty(value="assigned_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignedId() {
        return this.assignedId;
    }

    @JsonProperty(value="assigned_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignedId(String assignedId) {
        this.assignedId = assignedId;
    }

    public ArchivedActivity assignedDate(String assignedDate) {
        this.assignedDate = assignedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date ('yyyy-MM-dd HH:mm:ss.SSS') when the current archived activity was assigned, for example '2014-10-17 16:05:42.626'")
    @JsonProperty(value="assigned_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignedDate() {
        return this.assignedDate;
    }

    @JsonProperty(value="assigned_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignedDate(String assignedDate) {
        this.assignedDate = assignedDate;
    }

    public ArchivedActivity sourceObjectId(String sourceObjectId) {
        this.sourceObjectId = sourceObjectId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the original id of the archived activity before it was archived")
    @JsonProperty(value="sourceObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceObjectId() {
        return this.sourceObjectId;
    }

    @JsonProperty(value="sourceObjectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceObjectId(String sourceObjectId) {
        this.sourceObjectId = sourceObjectId;
    }

    public ArchivedActivity archivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the date (('yyyy-MM-dd HH:mm:ss.SSS')) when this archived activity was archived, for example '2014-10-17 16:05:42.626'")
    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchivedDate() {
        return this.archivedDate;
    }

    @JsonProperty(value="archivedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchivedDate(String archivedDate) {
        this.archivedDate = archivedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchivedActivity archivedActivity = (ArchivedActivity)o;
        return Objects.equals(this.id, archivedActivity.id) && Objects.equals((Object)this.type, (Object)archivedActivity.type) && Objects.equals(this.name, archivedActivity.name) && Objects.equals(this.displayName, archivedActivity.displayName) && Objects.equals(this.description, archivedActivity.description) && Objects.equals(this.displayDescription, archivedActivity.displayDescription) && Objects.equals((Object)this.state, (Object)archivedActivity.state) && Objects.equals(this.reachedStateDate, archivedActivity.reachedStateDate) && Objects.equals(this.lastUpdateDate, archivedActivity.lastUpdateDate) && Objects.equals(this.dueDate, archivedActivity.dueDate) && Objects.equals((Object)this.priority, (Object)archivedActivity.priority) && Objects.equals(this.processId, archivedActivity.processId) && Objects.equals(this.parentCaseId, archivedActivity.parentCaseId) && Objects.equals(this.rootCaseId, archivedActivity.rootCaseId) && Objects.equals(this.rootContainerId, archivedActivity.rootContainerId) && Objects.equals(this.executedBy, archivedActivity.executedBy) && Objects.equals(this.executedBySubstitute, archivedActivity.executedBySubstitute) && Objects.equals(this.actorId, archivedActivity.actorId) && Objects.equals(this.assignedId, archivedActivity.assignedId) && Objects.equals(this.assignedDate, archivedActivity.assignedDate) && Objects.equals(this.sourceObjectId, archivedActivity.sourceObjectId) && Objects.equals(this.archivedDate, archivedActivity.archivedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.name, this.displayName, this.description, this.displayDescription, this.state, this.reachedStateDate, this.lastUpdateDate, this.dueDate, this.priority, this.processId, this.parentCaseId, this.rootCaseId, this.rootContainerId, this.executedBy, this.executedBySubstitute, this.actorId, this.assignedId, this.assignedDate, this.sourceObjectId, this.archivedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchivedActivity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayDescription: ").append(this.toIndentedString(this.displayDescription)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    reachedStateDate: ").append(this.toIndentedString(this.reachedStateDate)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    processId: ").append(this.toIndentedString(this.processId)).append("\n");
        sb.append("    parentCaseId: ").append(this.toIndentedString(this.parentCaseId)).append("\n");
        sb.append("    rootCaseId: ").append(this.toIndentedString(this.rootCaseId)).append("\n");
        sb.append("    rootContainerId: ").append(this.toIndentedString(this.rootContainerId)).append("\n");
        sb.append("    executedBy: ").append(this.toIndentedString(this.executedBy)).append("\n");
        sb.append("    executedBySubstitute: ").append(this.toIndentedString(this.executedBySubstitute)).append("\n");
        sb.append("    actorId: ").append(this.toIndentedString(this.actorId)).append("\n");
        sb.append("    assignedId: ").append(this.toIndentedString(this.assignedId)).append("\n");
        sb.append("    assignedDate: ").append(this.toIndentedString(this.assignedDate)).append("\n");
        sb.append("    sourceObjectId: ").append(this.toIndentedString(this.sourceObjectId)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

