/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Retrieve business data value. Depending on the object attribute loading policy, the API returns either the full object in JSON representation or the HATEOAS links to the object attributes.  Long attributes use a string representation added in 7.0.1 as a workaround for the JavaScript integer spectrum issue.  Representation of object attributes with an _always load_ policy:  ```json {   \"persistenceId\": _number_, // <-- deprecated   \"persistenceId_string\": \"_number_\"   \"persistenceVersion\": _number_, // <-- deprecated   \"persistenceVersion_string\": \"_number_\"   \"attributeName\":_attributeType_   ... } ```  The string representation added in 7.0.1 for Long attributes is a workaround for the JavaScript integer spectrum issue.  HATEOAS representation of object attribute with a _load when needed_ policy: ```json \"links\":[    {    \"rel\":_string_    \"href\":_uri_    } ] ``` ")
@JsonPropertyOrder(value={"persistenceId_string", "persistenceVersion_string"})
public class BusinessData
extends HashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PERSISTENCE_ID_STRING = "persistenceId_string";
    private String persistenceIdString;
    public static final String JSON_PROPERTY_PERSISTENCE_VERSION_STRING = "persistenceVersion_string";
    private String persistenceVersionString;

    public BusinessData persistenceIdString(String persistenceIdString) {
        this.persistenceIdString = persistenceIdString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Id of the business data object")
    @JsonProperty(value="persistenceId_string")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPersistenceIdString() {
        return this.persistenceIdString;
    }

    @JsonProperty(value="persistenceId_string")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersistenceIdString(String persistenceIdString) {
        this.persistenceIdString = persistenceIdString;
    }

    public BusinessData persistenceVersionString(String persistenceVersionString) {
        this.persistenceVersionString = persistenceVersionString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the business data object instance")
    @JsonProperty(value="persistenceVersion_string")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPersistenceVersionString() {
        return this.persistenceVersionString;
    }

    @JsonProperty(value="persistenceVersion_string")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersistenceVersionString(String persistenceVersionString) {
        this.persistenceVersionString = persistenceVersionString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessData businessData = (BusinessData)o;
        return Objects.equals(this.persistenceIdString, businessData.persistenceIdString) && Objects.equals(this.persistenceVersionString, businessData.persistenceVersionString) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.persistenceIdString, this.persistenceVersionString, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessData {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    persistenceIdString: ").append(this.toIndentedString(this.persistenceIdString)).append("\n");
        sb.append("    persistenceVersionString: ").append(this.toIndentedString(this.persistenceVersionString)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

