/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The bonita platform")
@JsonPropertyOrder(value={"state", "version", "initialVersion", "previousVersion", "createdBy", "created"})
public class Platform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    public static final String JSON_PROPERTY_INITIAL_VERSION = "initialVersion";
    private String initialVersion;
    public static final String JSON_PROPERTY_PREVIOUS_VERSION = "previousVersion";
    private String previousVersion;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    public Platform state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="platform state")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public Platform version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the current version of the platform")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public Platform initialVersion(String initialVersion) {
        this.initialVersion = initialVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the version in which the platform was created")
    @JsonProperty(value="initialVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInitialVersion() {
        return this.initialVersion;
    }

    @JsonProperty(value="initialVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialVersion(String initialVersion) {
        this.initialVersion = initialVersion;
    }

    public Platform previousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the previous version the platform was in or empty if there is none")
    @JsonProperty(value="previousVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPreviousVersion() {
        return this.previousVersion;
    }

    @JsonProperty(value="previousVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreviousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
    }

    public Platform createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the user name of the platform administrator")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Platform created(String created) {
        this.created = created;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the creation date")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(String created) {
        this.created = created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Platform platform = (Platform)o;
        return Objects.equals((Object)this.state, (Object)platform.state) && Objects.equals(this.version, platform.version) && Objects.equals(this.initialVersion, platform.initialVersion) && Objects.equals(this.previousVersion, platform.previousVersion) && Objects.equals(this.createdBy, platform.createdBy) && Objects.equals(this.created, platform.created);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.version, this.initialVersion, this.previousVersion, this.createdBy, this.created});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Platform {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    initialVersion: ").append(this.toIndentedString(this.initialVersion)).append("\n");
        sb.append("    previousVersion: ").append(this.toIndentedString(this.previousVersion)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STARTED("STARTED"),
        STOPPED("STOPPED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

