/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Profile member")
@JsonPropertyOrder(value={"id", "profile_id", "role_id", "group_id", "user_id"})
public class ProfileMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PROFILE_ID = "profile_id";
    private String profileId;
    public static final String JSON_PROPERTY_ROLE_ID = "role_id";
    private String roleId;
    public static final String JSON_PROPERTY_GROUP_ID = "group_id";
    private String groupId;
    public static final String JSON_PROPERTY_USER_ID = "user_id";
    private String userId;

    public ProfileMember id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="profile member id")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ProfileMember profileId(String profileId) {
        this.profileId = profileId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of the profile for this mapping")
    @JsonProperty(value="profile_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfileId() {
        return this.profileId;
    }

    @JsonProperty(value="profile_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public ProfileMember roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of role, or -1 if the member type is not role")
    @JsonProperty(value="role_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoleId() {
        return this.roleId;
    }

    @JsonProperty(value="role_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public ProfileMember groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of group, or -1 if the member type is not group")
    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ProfileMember userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="id of user, or -1 if the member type is not user")
    @JsonProperty(value="user_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileMember profileMember = (ProfileMember)o;
        return Objects.equals(this.id, profileMember.id) && Objects.equals(this.profileId, profileMember.profileId) && Objects.equals(this.roleId, profileMember.roleId) && Objects.equals(this.groupId, profileMember.groupId) && Objects.equals(this.userId, profileMember.userId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.profileId, this.roleId, this.groupId, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileMember {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    profileId: ").append(this.toIndentedString(this.profileId)).append("\n");
        sb.append("    roleId: ").append(this.toIndentedString(this.roleId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

