/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.bonitasoft.web.client.api.SystemTenantApi;
import org.bonitasoft.web.client.feign.ApiProvider;
import org.bonitasoft.web.client.model.SystemTenant;
import org.bonitasoft.web.client.services.SystemService;
import org.bonitasoft.web.client.services.impl.base.AbstractService;
import org.bonitasoft.web.client.services.impl.base.ClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSystemService
extends AbstractService
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemService.class);

    public DefaultSystemService(ClientContext clientContext, ApiProvider apiProvider, ObjectMapper objectMapper) {
        super(apiProvider, objectMapper, clientContext);
    }

    @Override
    public boolean isTenantPaused() {
        log.info("Check if tenant is paused");
        SystemTenantApi tenantApi = this.apiProvider.get(SystemTenantApi.class);
        SystemTenant systemTenant = tenantApi.getSystemTenant("1");
        boolean paused = Optional.ofNullable(systemTenant.getPaused()).orElse(false);
        log.debug("Tenant paused: {}", (Object)paused);
        return paused;
    }
}

