/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.services.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] getFileFromZip(File zip, String filePath) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(filePath) || zipEntry.isDirectory()) continue;
                byte[] byArray = FileUtils.readFully(zipInputStream);
                return byArray;
            }
            throw new FileNotFoundException(String.format("Entry %s not found in zip", filePath));
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
        }
        return out.toByteArray();
    }
}

