/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.ApiResponse;
import org.bonitasoft.web.client.model.Group;
import org.bonitasoft.web.client.model.GroupCreateRequest;
import org.bonitasoft.web.client.model.GroupUpdateRequest;

public interface GroupApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/identity/group")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Group createGroup(GroupCreateRequest var1);

    @RequestLine(value="POST /API/identity/group")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Group> createGroupWithHttpInfo(GroupCreateRequest var1);

    @RequestLine(value="DELETE /API/identity/group/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteGroupById(@Param(value="id") String var1);

    @RequestLine(value="DELETE /API/identity/group/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteGroupByIdWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /API/identity/group/{id}")
    @Headers(value={"Accept: application/json"})
    public Group getGroupById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/identity/group/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Group> getGroupByIdWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /API/identity/group?p={p}&c={c}&f={f}&o={o}")
    @Headers(value={"Accept: application/json"})
    public List<Group> searchGroups(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4);

    @RequestLine(value="GET /API/identity/group?p={p}&c={c}&f={f}&o={o}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Group>> searchGroupsWithHttpInfo(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4);

    @RequestLine(value="GET /API/identity/group?p={p}&c={c}&f={f}&o={o}")
    @Headers(value={"Accept: application/json"})
    public List<Group> searchGroups(@QueryMap(encoded=true) SearchGroupsQueryParams var1);

    @RequestLine(value="GET /API/identity/group?p={p}&c={c}&f={f}&o={o}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Group>> searchGroupsWithHttpInfo(@QueryMap(encoded=true) SearchGroupsQueryParams var1);

    @RequestLine(value="PUT /API/identity/group/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateGroupById(@Param(value="id") String var1, GroupUpdateRequest var2);

    @RequestLine(value="PUT /API/identity/group/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateGroupByIdWithHttpInfo(@Param(value="id") String var1, GroupUpdateRequest var2);

    public static class SearchGroupsQueryParams
    extends HashMap<String, Object> {
        public SearchGroupsQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchGroupsQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchGroupsQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchGroupsQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }
    }
}

