/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.ApiResponse;
import org.bonitasoft.web.client.model.Profile;
import org.bonitasoft.web.client.model.ProfileCreateRequest;
import org.bonitasoft.web.client.model.ProfileUpdateRequest;

public interface ProfileApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/portal/profile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Profile createProfile(ProfileCreateRequest var1);

    @RequestLine(value="POST /API/portal/profile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Profile> createProfileWithHttpInfo(ProfileCreateRequest var1);

    @RequestLine(value="DELETE /API/portal/profile/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteProfileById(@Param(value="id") String var1);

    @RequestLine(value="DELETE /API/portal/profile/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteProfileByIdWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /API/portal/profile/{id}")
    @Headers(value={"Accept: application/json"})
    public Profile getProfileById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/portal/profile/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Profile> getProfileByIdWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="POST /services/profile/import")
    @Headers(value={"Content-Type: application/x-www-form-urlencoded", "Accept: application/json"})
    public void importProfiles(@Param(value="profilesDataUpload") String var1, @Param(value="importPolicy") String var2);

    @RequestLine(value="POST /services/profile/import")
    @Headers(value={"Content-Type: application/x-www-form-urlencoded", "Accept: application/json"})
    public ApiResponse<Void> importProfilesWithHttpInfo(@Param(value="profilesDataUpload") String var1, @Param(value="importPolicy") String var2);

    @RequestLine(value="GET /API/portal/profile?p={p}&c={c}&f={f}&s={s}&o={o}")
    @Headers(value={"Accept: application/json"})
    public List<Profile> searchProfiles(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="s") String var4, @Param(value="o") String var5);

    @RequestLine(value="GET /API/portal/profile?p={p}&c={c}&f={f}&s={s}&o={o}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Profile>> searchProfilesWithHttpInfo(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="s") String var4, @Param(value="o") String var5);

    @RequestLine(value="GET /API/portal/profile?p={p}&c={c}&f={f}&s={s}&o={o}")
    @Headers(value={"Accept: application/json"})
    public List<Profile> searchProfiles(@QueryMap(encoded=true) SearchProfilesQueryParams var1);

    @RequestLine(value="GET /API/portal/profile?p={p}&c={c}&f={f}&s={s}&o={o}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Profile>> searchProfilesWithHttpInfo(@QueryMap(encoded=true) SearchProfilesQueryParams var1);

    @RequestLine(value="PUT /API/portal/profile/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateProfileById(@Param(value="id") String var1, ProfileUpdateRequest var2);

    @RequestLine(value="PUT /API/portal/profile/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateProfileByIdWithHttpInfo(@Param(value="id") String var1, ProfileUpdateRequest var2);

    @RequestLine(value="POST /portal/profilesUpload")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public String uploadprofiles(@Param(value="file") File var1);

    @RequestLine(value="POST /portal/profilesUpload")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public ApiResponse<String> uploadprofilesWithHttpInfo(@Param(value="file") File var1);

    public static class SearchProfilesQueryParams
    extends HashMap<String, Object> {
        public SearchProfilesQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchProfilesQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchProfilesQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchProfilesQueryParams s(String value) {
            this.put("s", EncodingUtils.encode(value));
            return this;
        }

        public SearchProfilesQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }
    }
}

