/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.invoker;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.text.DateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bonitasoft.web.client.invoker.ApiResponseDecoder;
import org.bonitasoft.web.client.invoker.RFC3339DateFormat;
import org.bonitasoft.web.client.invoker.StringUtil;
import org.bonitasoft.web.client.invoker.auth.ApiKeyAuth;
import org.bonitasoft.web.client.invoker.auth.HttpBasicAuth;
import org.bonitasoft.web.client.invoker.auth.HttpBearerAuth;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApiClient {
    private static final Logger log = Logger.getLogger(ApiClient.class.getName());
    protected ObjectMapper objectMapper;
    private String basePath = "http://localhost:8080/bonita";
    private Map<String, RequestInterceptor> apiAuthorizations = new LinkedHashMap<String, RequestInterceptor>();
    private Feign.Builder feignBuilder;

    public ApiClient() {
        this.objectMapper = this.createObjectMapper();
        this.feignBuilder = Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.objectMapper))).decoder((Decoder)new ApiResponseDecoder(this.objectMapper)).logger((feign.Logger)new Slf4jLogger());
    }

    public ApiClient(String[] authNames) {
        this();
        for (String authName : authNames) {
            ApiKeyAuth auth;
            log.log(Level.FINE, "Creating authentication {0}", authName);
            if ("bonita_auth".equals(authName)) {
                auth = new ApiKeyAuth("cookie", "JSESSIONID");
            } else if ("bonita_token".equals(authName)) {
                auth = new ApiKeyAuth("header", "X-Bonita-API-Token");
            } else {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(String authName) {
        this(new String[]{authName});
    }

    public ApiClient(String authName, String apiKey) {
        this(authName);
        this.setApiKey(apiKey);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Map<String, RequestInterceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public void setApiAuthorizations(Map<String, RequestInterceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
    }

    public Feign.Builder getFeignBuilder() {
        return this.feignBuilder;
    }

    public ApiClient setFeignBuilder(Feign.Builder feignBuilder) {
        this.feignBuilder = feignBuilder;
        return this;
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new RFC3339DateFormat());
        objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNullableModule jnm = new JsonNullableModule();
        objectMapper.registerModule((Module)jnm);
        return objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends Api> T buildClient(Class<T> clientClass) {
        return (T)((Api)this.feignBuilder.target(clientClass, this.basePath));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        if (StringUtil.containsIgnoreCase(accepts, "application/json")) {
            return "application/json";
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        if (StringUtil.containsIgnoreCase(contentTypes, "application/json")) {
            return "application/json";
        }
        return contentTypes[0];
    }

    public void setBearerToken(String bearerToken) {
        HttpBearerAuth apiAuthorization = this.getAuthorization(HttpBearerAuth.class);
        apiAuthorization.setBearerToken(bearerToken);
    }

    public void setApiKey(String apiKey) {
        ApiKeyAuth apiAuthorization = this.getAuthorization(ApiKeyAuth.class);
        apiAuthorization.setApiKey(apiKey);
    }

    public void setCredentials(String username, String password) {
        HttpBasicAuth apiAuthorization = this.getAuthorization(HttpBasicAuth.class);
        apiAuthorization.setCredentials(username, password);
    }

    public RequestInterceptor getAuthorization(String authName) {
        return this.apiAuthorizations.get(authName);
    }

    public void addAuthorization(String authName, RequestInterceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        this.feignBuilder.requestInterceptor(authorization);
    }

    private <T extends RequestInterceptor> T getAuthorization(Class<T> type) {
        return (T)this.apiAuthorizations.values().stream().filter(requestInterceptor -> type.isAssignableFrom(requestInterceptor.getClass())).findFirst().orElseThrow(() -> new RuntimeException("No Oauth authentication or OAuth configured!"));
    }

    public static interface Api {
    }
}

